package com.prrsoft.visitormanagment

import android.content.Context
import android.content.SharedPreferences
import com.prrsoft.methodex.util.Constants
import com.prrsoft.methodex.util.Constants.Companion.KEY_MOBILE_NUMBER
import com.prrsoft.methodex.util.Constants.Companion.KEY_USER_ID_PREF
import com.prrsoft.methodex.util.Constants.Companion.SHARED_PREFERENCE

class PreferenceStore : Constants {

    fun putString(key: String, value: String) {
        val editor = preferences!!.edit()
        editor.putString(key, value).commit()
    }

    fun getString(key: String): String {
        return preferences!!.getString(key, "")
    }

    fun putBoolean(key: String, value: Boolean) {
        val editor = preferences!!.edit()
        editor.putBoolean(key, value).commit()
    }


    fun getBooleanLocation(key: String): Boolean {
        return preferences!!.getBoolean(key, true)
    }

    fun getBooleanNotificationChat(key: String): Boolean {
        return preferences!!.getBoolean(key, false)
    }

    fun getBooleanBusinessStatus(key: String): Boolean {
        return preferences!!.getBoolean(key, false)
    }

    fun putInt(key: String, value: Int) {
        val editor = preferences!!.edit()
        editor.putInt(key, value).commit()
    }

    fun getInt(key: String): Int {
        return preferences!!.getInt(key, -1)
    }

    fun flashWholePreferences(applicationContext: Context) {

        val editor = preferences!!.edit()

        editor.putString(Constants.KEY_USER_ID_PREF, "")

        editor.putString(KEY_USER_ID_PREF, "")
        editor.putString(KEY_MOBILE_NUMBER, "")

        editor.commit()

    }


    companion object {

        private var preferenceStore: PreferenceStore? = null
        private var preferences: SharedPreferences? = null

        fun getPreference(context: Context): PreferenceStore {

            if (preferences == null) {
                preferences = context.getSharedPreferences(SHARED_PREFERENCE, Context.MODE_MULTI_PROCESS)
            }
            if (preferenceStore == null) {
                preferenceStore = PreferenceStore()
            }
            return preferenceStore as PreferenceStore
        }
    }
}
