package com.prrsoft.methodex.ui.otpveryfy

import android.arch.lifecycle.ViewModelProvider
import android.arch.lifecycle.ViewModelProviders
import android.content.Intent
import android.os.Bundle
import android.text.Editable
import android.text.TextWatcher
import android.view.View
import android.widget.Toast
import com.prrsoft.methodex.BR
import com.prrsoft.methodex.R
import com.prrsoft.methodex.databinding.ActivityVeryFyOtpBinding
import com.prrsoft.methodex.ui.base.mvvm.BaseActivity
import com.prrsoft.methodex.ui.main.MainActivity
import kotlinx.android.synthetic.main.activity_very_fy_otp.*
import javax.inject.Inject

class VeryFyOtpActivity : BaseActivity<ActivityVeryFyOtpBinding, VeryFyViewModel>(), VeryFyNavigator {


    private var otpIdStr: String? = ""
    @Inject
    internal lateinit var mViewModelFactory: ViewModelProvider.Factory
    private var mActivityVeryFyOtpBinding: ActivityVeryFyOtpBinding? = null
    private var mVeryFyViewModel: VeryFyViewModel? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mActivityVeryFyOtpBinding = getViewDataBinding()
        mVeryFyViewModel?.setNavigator(this)
        mVeryFyViewModel?.startActivity()

        otpIdStr = intent.getStringExtra("OTP_ID")


    }

    override fun getViewModel(): VeryFyViewModel {
        mVeryFyViewModel = ViewModelProviders.of(this, mViewModelFactory).get(VeryFyViewModel::class.java)
        return mVeryFyViewModel as VeryFyViewModel
    }

    override fun getBindingVariable(): Int {
        return BR.viewModel
    }

    override fun getLayoutId(): Int {

        return R.layout.activity_very_fy_otp
    }


    override fun openEditTextChangeListner() {
        setAllOtpETextListener()
    }

    private fun setAllOtpETextListener() {

        etFirst.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {}

            override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                val text = "" + s
                if (text.length != 0) {
                    etSecoand.requestFocus()
                } else {
                    tvErrorMsg.visibility = View.GONE
                }
            }

            override fun afterTextChanged(s: Editable) {}
        })

        etSecoand.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {}

            override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                val text = "" + s
                if (text.length != 0) {
                    etThird.requestFocus()
                } else {
                    etFirst.requestFocus()
                }
            }

            override fun afterTextChanged(s: Editable) {}
        })

        etThird.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {}

            override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                val text = "" + s
                if (text.length != 0) {
                    etFourth.requestFocus()
                } else {
                    etSecoand.requestFocus()
                }
            }

            override fun afterTextChanged(s: Editable) {}
        })

        etFourth.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(s: CharSequence, start: Int, count: Int, after: Int) {}

            override fun onTextChanged(s: CharSequence, start: Int, before: Int, count: Int) {
                val text = "" + s
                if (text.length == 0) {
                    etThird.requestFocus()
                }
            }

            override fun afterTextChanged(s: Editable) {}
        })
    }

    override fun openHomePage() {

        startActivity(Intent(this, MainActivity::class.java))

    }

    override fun clickButton() {


        val otpFirstStr = etFirst.text.toString().trim()
        val otpSecoandStr = etSecoand.text.toString().trim()
        val otpThirdStr = etThird.text.toString().trim()
        val otpFourthStr = etFourth.text.toString().trim()


        val otpStr = otpFirstStr + otpSecoandStr + otpThirdStr + otpFourthStr

        if (otpFirstStr.isEmpty() || otpSecoandStr.isEmpty() || otpThirdStr.isEmpty() || otpFourthStr.isEmpty()) {
            Toast.makeText(this, "Enter OTP", Toast.LENGTH_SHORT).show()
            return
        }

        mVeryFyViewModel?.otpMatchRequest(otpIdStr!!, otpStr, this)

    }

}
