package com.prrsoft.methodex.ui.main

import android.arch.lifecycle.ViewModelProvider
import com.prrsoft.methodex.ViewModelProviderFactory
import com.prrsoft.methodex.util.SchedulerProvider
import dagger.Module
import dagger.Provides
import io.reactivex.disposables.CompositeDisposable

@Module
class MainActivityModule {

    @Provides
    internal fun mainViewModelProvider(mainViewModel: MainViewModel): ViewModelProvider.Factory =
         ViewModelProviderFactory(mainViewModel)


    @Provides
    internal fun provideMainViewModel(schedulerProvider: SchedulerProvider, compositeDisposable: CompositeDisposable): MainViewModel =
         MainViewModel( schedulerProvider,compositeDisposable)

}