package com.prrsoft.methodex.ui.main

import android.arch.lifecycle.ViewModelProvider
import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.widget.DrawerLayout
import android.support.v7.widget.Toolbar
import android.util.DisplayMetrics
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.WindowManager
import android.widget.*
import com.prrsoft.methodex.BR
import com.prrsoft.methodex.R
import com.prrsoft.methodex.databinding.ActivityMainBinding
import com.prrsoft.methodex.ui.base.mvvm.BaseActivity
import com.prrsoft.methodex.ui.fragment.bossTips.BossTipsFragment
import com.prrsoft.methodex.ui.fragment.bosstipsplan.BossTipsPlanFragment
import com.prrsoft.methodex.ui.fragment.home.HomeFragment
import com.prrsoft.methodex.ui.fragment.marketwatch.StockMarketFragment
import com.prrsoft.methodex.ui.fragment.topnews.TopNewsFragment
import com.prrsoft.methodex.util.Constants
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.activity_main.*
import javax.inject.Inject


class MainActivity : BaseActivity<ActivityMainBinding, MainViewModel>(), MainNavigator {

    private lateinit var mainDataListArray: java.util.ArrayList<MainDataList>
    private lateinit var userMobile: TextView
    private lateinit var imghome: ImageView
    private lateinit var toolBarTitel: TextView
    private lateinit var mDrawerLayout: DrawerLayout
    private lateinit var mToolBar: Toolbar
    private var screenHeight: Int = 0
    private var screenWidth: Int = 0
    private lateinit var leftSideDrawerView: LinearLayout
    @Inject
    internal lateinit var mViewModelFactory: ViewModelProvider.Factory
    private var mActivityMainBinding: ActivityMainBinding? = null
    private var mMainViewModel: MainViewModel? = null


    companion object {

        fun setData(hii: String) {

        }

    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mActivityMainBinding = getViewDataBinding()
        mMainViewModel?.setNavigator(this)

        val manager = getSystemService(WINDOW_SERVICE) as WindowManager
        val metrics = DisplayMetrics()
        manager.defaultDisplay.getMetrics(metrics)
        screenWidth = metrics.widthPixels
        screenHeight = metrics.heightPixels
        getIds()
        manageLeftSideDrawer()

        mainDataListArray = ArrayList<MainDataList>()
        mMainViewModel?.getMainDataList(this, mainDataListArray, recyclerView, llError)

    }


    override fun openHomePage() {
    }


    override fun getViewModel(): MainViewModel {
        mMainViewModel = ViewModelProviders.of(this, mViewModelFactory).get(MainViewModel::class.java)
        return mMainViewModel as MainViewModel
    }

    override fun getBindingVariable(): Int {
        return BR.viewModel;
    }

    override fun getLayoutId(): Int {
        return R.layout.activity_main;
    }


    //open Left side drawer

    private fun manageLeftSideDrawer() {

        leftSideDrawerView =
            LayoutInflater.from(this).inflate(R.layout.left_side_drawer_layout, null) as LinearLayout
        leftSideDrawerView!!.setLayoutParams(
            LinearLayout.LayoutParams(
                (screenWidth * 0.8).toInt(),
                LinearLayout.LayoutParams.MATCH_PARENT
            )
        )

        userMobile = leftSideDrawerView.findViewById<View>(R.id.drawerUserNameTView) as TextView

        drawerMenuView?.addView(leftSideDrawerView)

    }


    //    setupToolbar
    var drawerMenuView: LinearLayout? = null

    private fun getIds() {

        mToolBar = findViewById(R.id.toolbar) as Toolbar
        drawerMenuView = findViewById(R.id.drawerMenuView) as LinearLayout
        mDrawerLayout = findViewById(R.id.drawer_layout) as DrawerLayout
        setUpToolbar(R.drawable.navigationimg, "Dashboard")

    }


    private fun setUpToolbar(menu: Int, titleStr: String) {

        mToolBar.setContentInsetStartWithNavigation(0)

        toolBarTitel = mToolBar.findViewById(R.id.toolbar_title) as TextView
        imghome = mToolBar.findViewById(R.id.home) as ImageView
        imghome.setImageResource(menu)
        toolBarTitel.setText(titleStr)
        mToolBar.setNavigationIcon(null)

        imghome.setOnClickListener(View.OnClickListener {
            if (mDrawerLayout!!.isDrawerOpen(Gravity.LEFT)) {
                mDrawerLayout!!.closeDrawer(Gravity.LEFT)
            } else {
                mDrawerLayout!!.openDrawer(Gravity.LEFT)
            }
        })


    }

    override fun onResume() {
        super.onResume()
        userMobile.setText(PreferenceStore.getPreference(this).getString(Constants.KEY_EMAIL))
    }

}
