package com.prrsoft.methodex.ui.item

import android.app.Activity
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.util.Log
import android.view.View
import android.widget.LinearLayout
import android.widget.TextView
import android.widget.Toast
import com.android.volley.NetworkError
import com.android.volley.Response
import com.android.volley.ServerError
import com.android.volley.TimeoutError
import com.google.gson.Gson
import com.prrsoft.methodex.CIApp
import com.prrsoft.methodex.R
import com.prrsoft.methodex.network.RequestForItemDataList
import com.prrsoft.methodex.network.RequestForItemSummaryList
import com.prrsoft.methodex.ui.base.mvvm.BaseViewModel
import com.prrsoft.methodex.util.CommonUtil
import com.prrsoft.methodex.util.Constants
import com.prrsoft.methodex.util.SchedulerProvider
import io.reactivex.disposables.CompositeDisposable
import kotlinx.android.synthetic.main.activity_item_list.*
import kotlinx.android.synthetic.main.activity_item_list.view.*
import org.json.JSONException
import org.json.JSONObject
import org.json.JSONTokener
import javax.inject.Inject

class ItmViewModel @Inject internal constructor(
    schedulerProvider: SchedulerProvider,
    compositeDisposable: CompositeDisposable
) : BaseViewModel<ItemListNavigator>(schedulerProvider, compositeDisposable) {


    fun getMainDataList(
        id: String,
        activity: Activity?,
        mainDataListArray: ArrayList<ItemListDataProject>,
        recyclerView: RecyclerView?,
        llError: LinearLayout
    ) {


        CommonUtil.showLoadingDialog(activity)
        val loginRequest = RequestForItemDataList(id,
            Response.Listener<String> { response ->
                Log.d("ddjhggs",response)

                CommonUtil.hideDilog()
                try {
                    val json = JSONTokener(response).nextValue()
//                    val json = response
                    if (json is JSONObject) {

                        val status = if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                        val data = if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                        if (status == Constants.STATUS_SUCCESS) {


                            var mainDataList = ItemListDataProject()
                            mainDataList = Gson().fromJson(response, ItemListDataProject::class.java)
                            mainDataListArray.add(mainDataList)

                            recyclerView!!.layoutManager = LinearLayoutManager(activity)
//                            recyclerView.addItemDecoration(SimpleDividerItemDecoration(context))
                            recyclerView.adapter = ItemListProjectAdapter(
                                activity,
                                mainDataListArray,
                                recyclerView, llError

                            )


                        } else if (status == Constants.STATUS_EXCEPTION) {
                            llError.visibility = View.VISIBLE
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                        } else if (status == Constants.STATUS_FAILURE) {
                            llError.visibility = View.VISIBLE
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                        }
                    } else {
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                    Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                }
            },
            Response.ErrorListener { error ->
                llError.visibility = View.VISIBLE
                CommonUtil.hideDilog()
                if (error is ServerError)
                    Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                else if (error is TimeoutError)
                    Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                else if (error is NetworkError)
                    Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
            })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)
    }


    fun summery(
        id: String,
        activity: Activity?,
        mainDataListArray: ArrayList<ITEMSUMMARY>,
        recyclerView: RecyclerView?,
        llError: LinearLayout,
    txt_bogamnt:TextView,
    txt_excuteamnt:TextView,
    txt_percentage:TextView
    ) {


       // CommonUtil.showLoadingDialog(activity)
        val loginRequest = RequestForItemSummaryList(id,
            Response.Listener<String> { response ->
              Log.d("deessddd",response)
                CommonUtil.hideDilog()
                try {
                    val json = JSONTokener(response).nextValue()
//                    val json = response
                    if (json is JSONObject) {

                       val status = json.getString("status")
                       val bogamnt = json.getString("boq")
                       val executedamnt = json.getString("executed")
                       val percentage = json.getString("final_percentage")
                       /* txt_categrynametotal.text= bogamnt
                        txt_categrynametotal.setText(executedamnt)
                        txt_categrynametotal.setText(executedamnt)*/
                        Log.d("rrr",status)
                       // val data = if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""

                        if (status.equals("true")) {
                            llError.visibility = View.GONE

                            var mainDataList = ITEMSUMMARY()
                            mainDataList = Gson().fromJson(response, ITEMSUMMARY::class.java)
                            mainDataListArray.add(mainDataList)

                            recyclerView!!.layoutManager = LinearLayoutManager(activity)
//                            recyclerView.addItemDecoration(SimpleDividerItemDecoration(context))
                            recyclerView.adapter = ItemListSummaryAdapter(activity, mainDataListArray, recyclerView, llError

                            )
                        //Log.d("dddd",recyclerView)
                            txt_bogamnt.text= bogamnt
                            txt_excuteamnt.setText(executedamnt)
                            txt_percentage.setText(percentage)

                        }
                        else  {
                            llError.visibility = View.VISIBLE
                           // Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                        } /*else if (status == Constants.STATUS_FAILURE) {
                            llError.visibility = View.VISIBLE
                           // Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                        }*/
                    } else {
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                }
                catch (e: Exception) {
                    e.printStackTrace()
                   //Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                }
            },
            Response.ErrorListener { error ->
                llError.visibility = View.VISIBLE
                CommonUtil.hideDilog()
                if (error is ServerError)
                    Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                else if (error is TimeoutError)
                    Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                else if (error is NetworkError)
                    Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
            })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)
    }
}