package com.prrsoft.methodex.ui.item

import android.arch.lifecycle.ViewModelProvider
import com.prrsoft.methodex.ViewModelProviderFactory
import com.prrsoft.methodex.util.SchedulerProvider
import dagger.Module
import dagger.Provides
import io.reactivex.disposables.CompositeDisposable

@Module
class ItemViewModule {

    @Provides
    internal fun itemViewModelProvider(itemViewModel: ItmViewModel): ViewModelProvider.Factory =
        ViewModelProviderFactory(itemViewModel)


    @Provides
    internal fun provideItmViewModel(schedulerProvider: SchedulerProvider, compositeDisposable: CompositeDisposable): ItmViewModel =
        ItmViewModel( schedulerProvider,compositeDisposable)
}