package com.prrsoft.methodex.ui.item

import android.arch.lifecycle.ViewModelProvider
import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v7.widget.Toolbar
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.prrsoft.methodex.BR
import com.prrsoft.methodex.R
import com.prrsoft.methodex.databinding.ActivityItemListBinding
import com.prrsoft.methodex.ui.base.mvvm.BaseActivity
import kotlinx.android.synthetic.main.activity_item_list.*
import kotlinx.android.synthetic.main.activity_item_list.view.*
import kotlinx.android.synthetic.main.item_summary.view.*
import javax.inject.Inject

class ItemListActivity : BaseActivity<ActivityItemListBinding, ItmViewModel>(), ItemListNavigator {

    private lateinit var imghome: ImageView
    private lateinit var toolBarTitel: TextView
    private lateinit var mToolBar: Toolbar
    private lateinit var arrayList: ArrayList<ItemListDataProject>
    private lateinit var arrayLists: ArrayList<ITEMSUMMARY>
    @Inject
    internal lateinit var mViewModelFactory: ViewModelProvider.Factory
    private var mActivityItemListBinding: ActivityItemListBinding? = null
    private var mItmViewModel: ItmViewModel? = null
    lateinit var txt_categrynametotal:TextView
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mActivityItemListBinding = getViewDataBinding()
        mItmViewModel?.setNavigator(this)
        getIds(intent.getStringExtra("CUSTMER_NAME"))
        openSummry.setOnClickListener(){
            linear_summry.visibility = View.VISIBLE
            recyclerViewsummary.visibility = View.VISIBLE
            closeSummry.visibility = View.VISIBLE
            linear_total.visibility = View.VISIBLE
            view.visibility = View.VISIBLE
            openSummry.visibility = View.GONE

        }
        closeSummry.setOnClickListener(){
            linear_summry.visibility = View.GONE
            recyclerViewsummary.visibility = View.GONE
            openSummry.visibility = View.VISIBLE
            closeSummry.visibility = View.GONE
            linear_total.visibility = View.GONE
            view.visibility = View.GONE
        }
       /* txt_categrynametotal.text = "Total"
        txt_categrynametotal.text = arrayLists.bog*/
        setUi(
            intent.getStringExtra("CUSTMER_NAME"),
            intent.getStringExtra("CUSTMER_CARD"),
            intent.getStringExtra("PP_NO"),
            intent.getStringExtra("BOOKING_VOG"),
            intent.getStringExtra("BOOKING_BRANCH"),
            intent.getStringExtra("EX_BRANCH"),
            intent.getStringExtra("LOCATION"),
            intent.getStringExtra("PROJECT_MANAGER"),
            intent.getStringExtra("SUPER_VISOR")
        )

        arrayList = ArrayList<ItemListDataProject>()
        mItmViewModel?.getMainDataList(intent.getStringExtra("PROJECT_ID"), this, arrayList, recyclerView, llError)
       try {


        arrayLists = ArrayList<ITEMSUMMARY>()
        mItmViewModel?.summery(intent.getStringExtra("PROJECT_ID"), this, arrayLists, recyclerViewsummary, llError,txt_btqtotalamnt,txt_executeamnttotal,txt_percentagetotal)
       }catch (e:Exception){

       }
    }

    private fun setUi(
        cusName: String?,
        cusCard: String?,
        ppNo: String?,
        bookingVog: String?,
        bookingBranch: String?,
        exBranch: String?,
        location: String?,
        projectManager: String?,
        supervisor: String?
    ) {

        tvCustomerName.setText(cusName)
        tvCustomerCard.setText(cusCard)
        tvBookingBranch.setText(bookingBranch)
        tvBookingVog.setText(bookingVog)
        tvExecuting.setText(exBranch)
        tvLocation.setText(location)
        tvPpno.setText(ppNo)
        tvProjectManageger.setText(projectManager)
        tvSupervisor.setText(supervisor)


    }

    override fun getViewModel(): ItmViewModel {
        mItmViewModel = ViewModelProviders.of(this, mViewModelFactory).get(ItmViewModel::class.java)
        return mItmViewModel as ItmViewModel
    }

    override fun getBindingVariable(): Int {
        return BR.viewModel
    }

    override fun getLayoutId(): Int {
        return R.layout.activity_item_list
    }


    private fun getIds(name: String) {

        mToolBar = findViewById(R.id.toolbar) as Toolbar
        setUpToolbar(R.drawable.ic_arrow_back_black_24dp, name)

    }


    private fun setUpToolbar(menu: Int, titleStr: String) {

        mToolBar.setContentInsetStartWithNavigation(0)

        toolBarTitel = mToolBar.findViewById(R.id.toolbar_title) as TextView
        imghome = mToolBar.findViewById(R.id.home) as ImageView
        imghome.setImageResource(menu)
        toolBarTitel.setText(titleStr)
        mToolBar.setNavigationIcon(null)

        imghome.setOnClickListener(View.OnClickListener {
            finish()
        })


    }



  /*  private fun specificationMessage(messageNew: String) {

        val stringRequest = object : StringRequest(
            Method.POST, Const.URL_SAVE_CAHTTING,
            Response.Listener<String> { response ->
                Log.d("eeeepp",response)
                try {

                    if (response == null) {
                        // null response

                    } else {
                      //  Log.e(TAG, response.toString())

                        var json = JSONObject(response)

                  *//*      if (mStr_Status.equals(Const.KEY_SUCCESS)) {
                            //insert latest message in sqlite....
                                       db!!.insertNote(json.optString("input_message"),
                                           json.optString("date"),
                                           json.optBoolean("isremote").toString())
//                            SESSION_ID = json.optString("session_id")
//                            TOKEN = json.optString("token_id")
//                            if (isFirstTimeOpen) {
//                                initOpenTok()
//                                isFirstTimeOpen = false
//                            }


                        }*//*

                    }

                } catch (e: JSONException) {
                    e.printStackTrace()
                }
            },
            object : Response.ErrorListener {
                override fun onErrorResponse(volleyError: VolleyError) {
                }
            }) {
            @Throws(AuthFailureError::class)
            override fun getParams(): Map<String, String> {
                val params = HashMap<String, String>()
               *//* params["app_key"] = Const.AUTHENTICATION_TOKEN

                params["message"] = messageNew
                params[Const.KEY_USER_TYPE] =
                    MyPreferenceStore.getPreference(this@MessageChatActivity)
                        .getString(MyPreferenceStore.PREF_USER_TYPE)*//*


                return params
            }
        }
    }*/
}
