package com.prrsoft.methodex.ui.fragment.topnews

import android.support.v4.app.FragmentActivity
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.prrsoft.methodex.R
import kotlinx.android.synthetic.main.row_news_list.view.*
import java.util.ArrayList
import android.os.Bundle
import android.support.v4.app.FragmentManager
import com.prrsoft.methodex.ui.fragment.newsDetailsFragment.NewsDetailsFragment
import com.prrsoft.methodex.util.Constants.Companion.BASE_IMAGE_URL


class NewsListAdapter(
    private val context: FragmentActivity? = null,
    private val newsDataListArray: ArrayList<NewsDataListModel>,
    private val frameContainer: Int,
    private val childFragmentManager: FragmentManager
) :
    RecyclerView.Adapter<NewsListAdapter.HomeViewHolder>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HomeViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.row_news_list, parent, false)
        return HomeViewHolder(view)
    }

    override fun getItemCount(): Int = newsDataListArray[0].newsList!!.size

    override fun onBindViewHolder(holder: HomeViewHolder, position: Int) {
        newsDataListArray[0].newsList?.get(position)?.let { holder.bind(it) }
    }

    inner class HomeViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        fun bind(movies: NewsList) = with(itemView) {
            val requestOptions = RequestOptions()
            requestOptions.placeholder(R.drawable.logo)
            Glide.with(this.context)
                .load(BASE_IMAGE_URL + movies.image)
                .apply(requestOptions)
                .into(ivNewsIcon)
            tvNewsHeading.text = movies.headline
            tvNewsContent.text = movies.news
            setOnClickListener {


                fragmentJump(newsDataListArray[0].newsList, layoutPosition)
            }
        }
    }

    private fun fragmentJump(
        mItemSelected: List<NewsList>?,
        layoutPosition: Int
    ) {
        val mFragment = NewsDetailsFragment()
        val mBundle = Bundle()
//        mBundle.putParcelable("item_selected_key", mItemSelected)
//        mBundle.putParcelableArrayList("isSelectedArray",mItemSelected)
        mBundle.putString("NEWS_ID", "" + mItemSelected?.get(layoutPosition)?.id)
        mFragment.setArguments(mBundle)
        childFragmentManager.beginTransaction().replace(frameContainer, mFragment).addToBackStack(null).commit()
    }


}


