package com.prrsoft.methodex.ui.fragment.marketwatch

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup

import com.prrsoft.methodex.R
import com.prrsoft.methodex.util.Constants
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.stock_market_fragment.*

class StockMarketFragment : Fragment() {

    companion object {
        val TAG = StockMarketFragment::class.java.simpleName
        fun newInstance() = StockMarketFragment()
    }

    private lateinit var shareMarketList: java.util.ArrayList<SharemarketDataList>
    private lateinit var viewModel: StockMarketViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.stock_market_fragment, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProviders.of(this).get(StockMarketViewModel::class.java)

        shareMarketList = ArrayList<SharemarketDataList>()
        viewModel.getShareMarketList(
            activity,
            PreferenceStore.getPreference(activity!!).getString(Constants.KEY_USER_ID_PREF),
            shareMarketList,
            recyclerView,
            R.id.frameContainer,
            childFragmentManager
        )

    }

}
