package com.prrsoft.methodex.ui.fragment.marketwatch

import android.os.Bundle
import android.support.v4.app.FragmentActivity
import android.support.v4.app.FragmentManager
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.prrsoft.methodex.R
import com.prrsoft.methodex.ui.fragment.newsDetailsFragment.NewsDetailsFragment
import kotlinx.android.synthetic.main.market_single_layout.view.*
import java.util.ArrayList

class ShareMarketListAdapter(
    private val context: FragmentActivity? = null,
    private val shareMarketListArray: ArrayList<SharemarketDataList>,
    private val frameContainer: Int,
    private val childFragmentManager: FragmentManager,
    private val recyclerView: RecyclerView
) :
    RecyclerView.Adapter<ShareMarketListAdapter.HomeViewHolder>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HomeViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.market_single_layout, parent, false)
        return HomeViewHolder(view)
    }

    override fun getItemCount(): Int = shareMarketListArray[0].shareMarketList!!.size

    override fun onBindViewHolder(holder: HomeViewHolder, position: Int) {
        shareMarketListArray[0].shareMarketList?.get(position)?.let { holder.bind(it) }
    }

    inner class HomeViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        fun bind(shareMarket: ShareMarketList) = with(itemView) {
            //            val requestOptions = RequestOptions()
//            requestOptions.placeholder(R.drawable.logo)
//            Glide.with(this.context)
//                .load(Constants.BASE_IMAGE_URL + shareMarket.image)
//                .apply(requestOptions)
//                .into(ivNewsIcon)
            tvCompanyName.text = shareMarket.companyName
            tvLow.text = shareMarket.low
            tvCurrent.text = shareMarket.currentValue
            tvHigh.text = shareMarket.high
            tvClose.text = shareMarket.prClose
            tvDate.text = shareMarket.date + " at " + shareMarket.time
            setOnClickListener {


            }

            ivDelete.setOnClickListener {

                StockMarketViewModel().deleateRecord(shareMarket.companyId, context,shareMarketListArray,layoutPosition,recyclerView,shareMarket)
            }
        }
    }

    private fun fragmentJump(
        mItemSelected: List<ShareMarketList>?,
        layoutPosition: Int
    ) {
        val mFragment = NewsDetailsFragment()
        val mBundle = Bundle()
//        mBundle.putParcelable("item_selected_key", mItemSelected)
//        mBundle.putParcelableArrayList("isSelectedArray",mItemSelected)
        mBundle.putString("NEWS_ID", "" + mItemSelected?.get(layoutPosition)?.companyId)
        mFragment.setArguments(mBundle)
        childFragmentManager.beginTransaction().replace(frameContainer, mFragment).addToBackStack(null).commit()
    }


}


