package com.prrsoft.methodex.ui.fragment.freetips

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup

import com.prrsoft.methodex.R
import com.prrsoft.methodex.ui.fragment.bossTips.TipsDataList
import com.prrsoft.methodex.util.Constants
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.boss_tips_fragment.*

class FreeTipsFragment : Fragment() {

    companion object {
        val TAG = FreeTipsFragment::class.java.simpleName
        fun newInstance() = FreeTipsFragment()
    }

    private lateinit var freeTipsFragment: java.util.ArrayList<TipsDataList>
    private lateinit var viewModel: FreeTipsViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.free_tips_fragment, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProviders.of(this).get(FreeTipsViewModel::class.java)

        freeTipsFragment = ArrayList<TipsDataList>()

        viewModel.getTipsListData(
            activity,
            PreferenceStore.getPreference(activity!!).getString(Constants.KEY_USER_ID_PREF),
            freeTipsFragment,
            recyclerView,
            R.id.frameContainer,
            childFragmentManager, llError
        )
    }

}
