package com.prrsoft.methodex.ui.fragment.bosstipsplan

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup

import com.prrsoft.methodex.R
import com.prrsoft.methodex.util.Constants
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.boss_tips_plan_fragment.*

class BossTipsPlanFragment : Fragment() {

    companion object {
        val TAG = BossTipsPlanFragment::class.java.simpleName
        fun newInstance() = BossTipsPlanFragment()
    }

    private lateinit var planDataListArray: java.util.ArrayList<PlanDataList>
    private lateinit var viewModel: BossTipsPlanViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.boss_tips_plan_fragment, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProviders.of(this).get(BossTipsPlanViewModel::class.java)

        planDataListArray = ArrayList<PlanDataList>()
        viewModel.getBossTipsPlans(
            activity,
            PreferenceStore.getPreference(activity!!).getString(Constants.KEY_USER_ID_PREF),
            planDataListArray,
            recyclerView,
            R.id.frameContainer,
            childFragmentManager
        )

        viewModel.getTremAndCondition(tvTermAndCondition, activity!!)

    }

}
