package com.prrsoft.methodex.ui.fragment.bosstipsplan

import android.support.v4.app.FragmentActivity
import android.support.v4.app.FragmentManager
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.prrsoft.methodex.R
import kotlinx.android.synthetic.main.single_radio_button_screen.view.*
import java.util.ArrayList

class BossTipsPlanAdapter(
    private val context: FragmentActivity? = null,
    private val planDataListArray: ArrayList<PlanDataList>,
    private val frameContainer: Int,
    private val childFragmentManager: FragmentManager,
    private val recyclerView: RecyclerView
) :
    RecyclerView.Adapter<BossTipsPlanAdapter.HomeViewHolder>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HomeViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.single_radio_button_screen, parent, false)
        return HomeViewHolder(view)
    }

    override fun getItemCount(): Int = planDataListArray[0].tipsPlanList!!.size

    override fun onBindViewHolder(holder: HomeViewHolder, position: Int) {
        planDataListArray[0].tipsPlanList?.get(position)?.let { holder.bind(it) }
    }

    inner class HomeViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        private var flagCount: Int = 0

        fun bind(tipsPlan: TipsPlanList) = with(itemView) {

            if (flagCount == layoutPosition) {

                rbButton.isChecked = true
                flagCount = layoutPosition
//                recyclerView.adapter?.notifyDataSetChanged()
            } else {
                rbButton.isChecked = false
                flagCount = layoutPosition
//                recyclerView.adapter?.notifyDataSetChanged()
            }

            rbButton.text = tipsPlan.planName


            setOnClickListener {


            }

        }
    }

//    private fun fragmentJump(
//        mItemSelected: List<ShareMarketList>?,
//        layoutPosition: Int
//    ) {
//        val mFragment = NewsDetailsFragment()
//        val mBundle = Bundle()
////        mBundle.putParcelable("item_selected_key", mItemSelected)
////        mBundle.putParcelableArrayList("isSelectedArray",mItemSelected)
//        mBundle.putString("NEWS_ID", "" + mItemSelected?.get(layoutPosition)?.companyId)
//        mFragment.setArguments(mBundle)
//        childFragmentManager.beginTransaction().replace(frameContainer, mFragment).addToBackStack(null).commit()
//    }


}


