package com.prrsoft.methodex.ui.fragment.bossTips

import android.arch.lifecycle.ViewModel;
import android.support.v4.app.FragmentActivity
import android.support.v4.app.FragmentManager
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.view.View
import android.widget.LinearLayout
import android.widget.Toast
import com.android.volley.NetworkError
import com.android.volley.Response
import com.android.volley.ServerError
import com.android.volley.TimeoutError
import com.google.gson.Gson
import com.prrsoft.methodex.CIApp
import com.prrsoft.methodex.R
import com.prrsoft.methodex.network.RequestForTipsList
import com.prrsoft.methodex.util.CommonUtil
import com.prrsoft.methodex.util.Constants
import org.json.JSONException
import org.json.JSONObject
import org.json.JSONTokener
import java.util.ArrayList

class BossTipsViewModel : ViewModel() {

    fun getTipsListData(
        activity: FragmentActivity?,
        userId: String,
        tipsDataListArray: ArrayList<TipsDataList>,
        recyclerView: RecyclerView?,
        frameContainer: Int,
        childFragmentManager: FragmentManager,
        llError: LinearLayout
    ) {


        CommonUtil.showLoadingDialog(activity)
        val loginRequest = RequestForTipsList(userId, "paid",
                Response . Listener < String > { response ->

            CommonUtil.hideDilog()
            try {
                val json = JSONTokener(response).nextValue()
//                    val json = response
                if (json is JSONObject) {

                    val status = if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                    val data = if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                    if (status == Constants.STATUS_SUCCESS) {


                        var tipstData = TipsDataList()
                        tipstData = Gson().fromJson(response, TipsDataList::class.java)
                        tipsDataListArray.add(tipstData)

                        recyclerView!!.layoutManager = LinearLayoutManager(activity)
//                            recyclerView.addItemDecoration(SimpleDividerItemDecoration(context))
                        recyclerView.adapter = BossTipListAdapter(
                            activity,
                            tipsDataListArray,
                            frameContainer,
                            childFragmentManager, recyclerView, llError

                        )


                    } else if (status == Constants.STATUS_EXCEPTION) {
                        llError.visibility = View.VISIBLE
                        Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                    } else if (status == Constants.STATUS_FAILURE) {
                        llError.visibility = View.VISIBLE
                        Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                    }
                } else {
                    Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                }
            } catch (e: JSONException) {
                e.printStackTrace()
                Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
            }
        },
            Response.ErrorListener { error ->
                llError.visibility = View.VISIBLE
                CommonUtil.hideDilog()
                if (error is ServerError)
                    Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                else if (error is TimeoutError)
                    Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                else if (error is NetworkError)
                    Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
            })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)
    }

}
