package com.prrsoft.methodex.network

import com.android.volley.AuthFailureError
import com.android.volley.Request
import com.android.volley.Response
import com.android.volley.toolbox.StringRequest
import com.prrsoft.methodex.util.Constants
import java.util.HashMap

class RequestForSaveQuantity(
    cust_id: String,
    item_id: String,
    boq_amount: String,
    percentage: String,
    executed_quantity: String,
    id: String,

    listener: Response.Listener<String>,
    errorListener: Response.ErrorListener
) : StringRequest(Request.Method.POST, GET_FIND_PERCENTAGE, listener, errorListener) {
    private val parameters: MutableMap<String, String>

    init {
        parameters = HashMap()
        parameters["app_key"] = Constants.API_KEYV
        parameters["cust_id"] = cust_id
        parameters["item_id"] = item_id
        parameters["boq_amount"] = boq_amount
        parameters["percentage"] = percentage
        parameters["executed_quantity"] = executed_quantity
        parameters["id"] = id
    }

    @Throws(AuthFailureError::class)
    override fun getParams(): Map<String, String> {
        return parameters
    }

    companion object {
        private val GET_FIND_PERCENTAGE = Constants.GET_SAVE_DATA1
    }
}