package com.prrsoft.methodex.network

import com.android.volley.AuthFailureError
import com.android.volley.Request
import com.android.volley.Response
import com.android.volley.toolbox.StringRequest
import com.prrsoft.methodex.util.Constants
import java.util.*

class MatchOtpRequest(
    otp: String,
    id: String,
    listener: Response.Listener<String>,
    errorListener: Response.ErrorListener
) : StringRequest(Request.Method.POST, OTP_VERYFY_URL, listener, errorListener) {
    private val parameters: MutableMap<String, String>

    init {
        parameters = HashMap()
        parameters["otp"] = otp
        parameters["otp_id"] = id
        parameters["app_key"] = Constants.API_KEYV
    }

    @Throws(AuthFailureError::class)
    override fun getParams(): Map<String, String> {
        return parameters
    }

    companion object {
        private val OTP_VERYFY_URL = Constants.OTP_VERYFY_URL
    }
}