package com.prrsoft.methodex.di.module

import android.app.Application
import android.content.Context
import com.prrsoft.methodex.di.PreferenceInfo
import com.prrsoft.methodex.preference.AppPreferenceHelper
import com.prrsoft.methodex.preference.PreferenceHelper
import com.prrsoft.methodex.util.AppConstants
import com.prrsoft.methodex.util.SchedulerProvider
import dagger.Module
import dagger.Provides
import io.reactivex.disposables.CompositeDisposable
import javax.inject.Singleton

@Module
class AppModule {

    @Provides
    @Singleton
    internal fun provideContext(context: Application): Context = context

    @Provides
    @PreferenceInfo
    internal fun provideprefFileName(): String = AppConstants.PREF_NAME

    @Provides
    @Singleton
    internal fun providePrefHelper(appPreferenceHelper: AppPreferenceHelper): PreferenceHelper = appPreferenceHelper

    @Provides
    internal fun provideCompositeDisposable(): CompositeDisposable = CompositeDisposable()

    @Provides
    internal fun provideSchedulerProvider(): SchedulerProvider = SchedulerProvider()

}