package com.prrsoft.methodex.di.builder;

import android.app.Activity;
import com.prrsoft.methodex.ui.login.LoginActivityModule;
import com.prrsoft.methodex.ui.login.LoginScreenActivity;
import dagger.Binds;
import dagger.Module;
import dagger.Subcomponent;
import dagger.android.ActivityKey;
import dagger.android.AndroidInjector;
import dagger.multibindings.IntoMap;

@Module(
  subcomponents = ActivityBuilder_BindLoginScreenActivity.LoginScreenActivitySubcomponent.class
)
public abstract class ActivityBuilder_BindLoginScreenActivity {
  private ActivityBuilder_BindLoginScreenActivity() {}

  @Binds
  @IntoMap
  @ActivityKey(LoginScreenActivity.class)
  abstract AndroidInjector.Factory<? extends Activity> bindAndroidInjectorFactory(
      LoginScreenActivitySubcomponent.Builder builder);

  @Subcomponent(modules = LoginActivityModule.class)
  public interface LoginScreenActivitySubcomponent extends AndroidInjector<LoginScreenActivity> {
    @Subcomponent.Builder
    abstract class Builder extends AndroidInjector.Builder<LoginScreenActivity> {}
  }
}
