package com.prrsoft.methodex.ui.specificationlist

import android.app.Activity
import android.support.v7.widget.RecyclerView
import android.text.Editable
import android.text.TextWatcher
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.inputmethod.EditorInfo
import android.widget.LinearLayout
import android.widget.Toast
import com.android.volley.NetworkError
import com.android.volley.Response
import com.android.volley.ServerError
import com.android.volley.TimeoutError
import com.prrsoft.methodex.CIApp
import com.prrsoft.methodex.R
import com.prrsoft.methodex.network.RequestForSaveData
import com.prrsoft.methodex.util.CommonUtil
import com.prrsoft.methodex.util.Constants
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.single_project_list_specification.view.*
import org.json.JSONException
import org.json.JSONObject
import org.json.JSONTokener
import java.text.DecimalFormat

class SpecificationListAdapter(
    private val context: Activity? = null,
    private val tipsDataListArray: ArrayList<SpeficationListData>,
    private val recyclerView: RecyclerView,
    private val llError: LinearLayout,
    var excuteqtyrepeat: String = ""

) :
    RecyclerView.Adapter<SpecificationListAdapter.HomeViewHolder>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HomeViewHolder {
        val view = LayoutInflater.from(context)
            .inflate(R.layout.single_project_list_specification, parent, false)
        return HomeViewHolder(view)
    }

    override fun getItemCount(): Int {
        if (tipsDataListArray.size == 0) {
            llError.visibility = View.VISIBLE
            return 0
        }
        if (tipsDataListArray[0].sPECIFICATIONDATALIST?.size == null) {
            llError.visibility = View.VISIBLE
            return 0
        }
        llError.visibility = View.GONE
        return tipsDataListArray[0].sPECIFICATIONDATALIST!!.size
    }


    override fun onBindViewHolder(holder: HomeViewHolder, position: Int) {
        tipsDataListArray[0].sPECIFICATIONDATALIST?.get(position)?.let { holder.bind(it, position) }

    }

    inner class HomeViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        fun bind(
            tipsList: SPECIFICATIONDATALISTItem,
            position: Int
        ) = with(itemView) {
            var linear_excutedquantity =
                itemView.findViewById<LinearLayout>(R.id.linear_excutedquantity)
            if (position == 0) {
                linear_excutedquantity.visibility = View.GONE
                linear_excutedammount.visibility = View.VISIBLE
                var bog_qty: String = tipsList.bOQQty!!
                var bog_rate: String = tipsList.boqRate!!
                val bog_amount: String = (((bog_qty.toDouble() * bog_rate.toDouble())).toString())
                PreferenceStore.getPreference(context).putString("BOG_AMOUNT", "" + bog_amount)
                // Toast.makeText(context,bog_amount,Toast.LENGTH_LONG).show()
                tvPercentage.text =
                    tipsList.executedQtyPer

            }
            tvTital.text =
                tipsList.specification
            // linear_excutedammount
            txt_specificationdetails.text =
                tipsList.specification
            txt_executedammount.text = tipsList.executedAmount
            tvUnit.text =
                tipsList.unit
            tvboq.text =
                tipsList.bOQQty

            Log.d("percentage", tipsList.bOQQty)

            etExQTY!!.setText(tipsList.executedQty)

            etExQTY!!.setImeOptions(EditorInfo.IME_ACTION_DONE);

            /*  etExQTY.setOnClickListener(){
                  etExQTY.text.toString().trim()
                //  Toast.makeText(context,etExQTY,Toast.LENGTH_LONG).s
                  Log.d("qty",etExQTY.text.toString().trim())
              }*/
            tvPercentagesec!!.setText(tipsList.executedQtyPer)

            if (position == 0) {
                tvPercentage.visibility = View.VISIBLE
                tvPercentagesec.visibility = View.GONE
            } else {
                tvPercentagesec.visibility = View.VISIBLE
                tvPercentage.visibility = View.GONE

            }
            try {

                etExQTY!!.addTextChangedListener(object : TextWatcher {
                    override fun afterTextChanged(s: Editable?) {


                    }

                    override fun beforeTextChanged(
                        s: CharSequence?,
                        start: Int,
                        count: Int,
                        after: Int
                    ) {
                    }

                    override fun onTextChanged(
                        s: CharSequence?,
                        start: Int,
                        before: Int,
                        count: Int
                    ) {
                        if (s!!.length != 0) {
                            try{
                                var ext=etExQTY.text.toString().toFloat()
                                val tvPercentages =
                                    (ext / (tvboq.text.toString().toFloat())) * tipsList.weightagePer.toString().toFloat()



                                tvPercentagesec!!.setText("" + String.format("%.2f", tvPercentages))

                            }catch (e:Exception){

                            }

                        }
                    }

                })

                /*  if() {
                      val tvPercentages =
                          ((etExQTY.text.toString().toDouble()) / (tvboq.text.toString().toDouble())) * tipsList.weightagePer.toString().toDouble()
                      tvPercentagesec!!.setText(tvPercentages.toString())
                  }
                  else{
                      val tvPercentagess = ((etExQTY.text.toString().trim().toDouble())/ (tvboq.text.toString().toDouble()))*tipsList.weightagePer.toString().toDouble()
                     //val tvPercentages = (("1".toDouble())/ ("1".toDouble()))*"200".toDouble()
                  }*/

            } catch (e: Exception) {

            }
            ic_down.setOnClickListener {
                if (layoutDetail.visibility == View.VISIBLE)
                    layoutDetail.visibility = View.GONE
                else
                    layoutDetail.visibility = View.VISIBLE
            }

            txt_specification.setOnClickListener {
                if (linear_specification.visibility == View.VISIBLE)
                    linear_specification.visibility = View.GONE
                else
                    linear_specification.visibility = View.VISIBLE
            }

            etExQTY.addTextChangedListener(object : TextWatcher {

                override fun afterTextChanged(s: Editable) {

                }

                override fun beforeTextChanged(
                    s: CharSequence, start: Int,
                    count: Int, after: Int
                ) {

                    tvPercentage.setText("")
                }

                override fun onTextChanged(
                    str: CharSequence, start: Int,
                    before: Int, count: Int
                ) {


//                    requestForPercentage(
//                        tipsList.bOQQty!!,
//                        tipsList.weightagePer!!,
//                        str.toString(),
//                        // tvPercentage,
//                        PreferenceStore.getPreference(context).getString("ITEM_IDDD")
//
//                    )
                }
            })
            if (position == 0) {
                ivSubmit.setOnClickListener {
                    var edtExQTY = etExQTY.text.toString().trim()

                    var tvPercentages = tvPercentage.text.toString().trim()
                    saveData(

                        PreferenceStore.getPreference(context!!).getString("CUST_ID"),
                        PreferenceStore.getPreference(context).getString("ITEM_IDDD"),
                        PreferenceStore.getPreference(context).getString("BOG_AMOUNT"),
                        tvPercentages,
                        edtExQTY,
                        tipsList.id!!


                        //  tipsList.executedQtyPer!!,

                    )
                }
            } else {

                ivSubmit.setOnClickListener {
                    var edtExQTY = etExQTY.text.toString().trim()


                    var tvPercentagesec = tvPercentagesec.text.toString().trim()
                    if (etExQTY.text.toString().trim().equals("")) {
                        Toast.makeText(context, "Enter Executed Qty", Toast.LENGTH_LONG).show()
                    } else if (tvPercentagesec.equals("")) {
                        Toast.makeText(context, "Try Again", Toast.LENGTH_LONG).show()

                    }
                    /*  else if (tvboq.text as String>etExQTY.text.toString()){
                          Toast.makeText(context, "Executed Qty can't be greater than BOQ QTY ", Toast.LENGTH_LONG).show()
                          //etExQTY.text.toString().trim()<=tvboq.text as String
                      }*/
                    else if ((etExQTY.text.toString().toDouble()) > (tvboq.text.toString().toDouble())) {
                        Toast.makeText(
                            context,
                            "Executed Qty can't be greater than BOQ QTY ",
                            Toast.LENGTH_LONG
                        ).show()
                    }
                    /*  else if ((tipsList.weightagePer.toString().toInt())>(0)){
                         // Toast.makeText(context, "Executed Qty can't be greater than BOQ QTY ", Toast.LENGTH_LONG).show()
                      }*/
                    else {
                        saveData(
                            PreferenceStore.getPreference(context!!).getString("CUST_ID"),
                            PreferenceStore.getPreference(context).getString("ITEM_IDDD"),
                            PreferenceStore.getPreference(context).getString("BOG_AMOUNT"),
                            tvPercentagesec,
                            edtExQTY,
                            tipsList.id!!
                        )
                    }
                    /*      var refresh =
                              itemView.findViewById<SwipeRefreshLayout>(R.id.refresh)

                          refresh.setOnRefreshListener {
                              refresh.setRefreshing(false);
                              saveData(

                                  PreferenceStore.getPreference(context!!).getString("CUST_ID"),
                                  PreferenceStore.getPreference(context).getString("ITEM_IDDD"),
                                  PreferenceStore.getPreference(context).getString("BOG_AMOUNT"),
                                  tvPercentage,
                                  edtExQTY,
                                  tipsList.id!!


                                  //  tipsList.executedQtyPer!!,

                              )
                          }*/
//                val intent = Intent(context, SpeficationFieldActivity::class.java)
//                intent.putExtra("NAME", tipsList.specification)
//                intent.putExtra("ID", tipsList.id)
//
//                PreferenceStore.getPreference(context).putString("IIID",""+tipsList.id)
//                context.startActivity(intent)
                    /*              val edtExQTY
                                   if (edtExQTY.text.toString().trim().equals("")) {
                                       edtExQTY.setError("Please Enter Executed Qty")
                                       return
                                   }
                                   if (tvPercentage.text.toString().trim().length == 0) {
                                       tvPercentage.setError("Please Enter Password")
                                       return
                                   }
                   //        if (etPassword.text.toString().trim().length < 6) {
                   //            etPassword.setError("Please Enter Valid Password")
                   //            return
                   //        }
                                   mLoginViewModel?.userLoginWs(edtExQTY.text.toString().trim(), tvPercentage.text.toString().trim(),this)*/


                }
            }

        }


//        fun requestForPercentage(
//            boq_quantity: String,
//            weightage: String,
//            executed_quantity: String,
//          // tvPercentage: TextView?,
//            id: String
//        ) {
//
//
//            val loginRequest =
//                RequestForFindPercentage(boq_quantity,
//                    weightage,
//                    executed_quantity,
//                    id,
//                    Response.Listener<String> { response ->
//                        Log.d("pdpdpd",id)
//                        CommonUtil.hideDilog()
//                        try {
//                            val json = JSONTokener(response).nextValue()
////                    val json = response
//                            if (json is JSONObject) {
//
//                                val status =
//                                    if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
//                                val data =
//                                    if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
//                                if (status == Constants.STATUS_SUCCESS) {
//
//                                //tvPercentage!!.setText(json.optString("PERCENTAGE_DATA"))
//
//                                } else if (status == Constants.STATUS_EXCEPTION) {
//                                    Toast.makeText(context!!, data, Toast.LENGTH_SHORT).show()
//                                } else if (status == Constants.STATUS_FAILURE) {
//                                    Toast.makeText(context!!, data, Toast.LENGTH_SHORT).show()
//
//                                }
//                            } else {
//                                Toast.makeText(
//                                    context!!,
//                                    R.string.someting_went_wrong,
//                                    Toast.LENGTH_SHORT
//                                ).show()
//                            }
//                        } catch (e: JSONException) {
//                            e.printStackTrace()
//                            Toast.makeText(
//                                context!!,
//                                R.string.someting_went_wrong,
//                                Toast.LENGTH_SHORT
//                            ).show()
//                        }
//                    },
//                    Response.ErrorListener { error ->
//                        CommonUtil.hideDilog()
//                        if (error is ServerError)
//                            Toast.makeText(context!!, "Server Error", Toast.LENGTH_SHORT).show()
//                        else if (error is TimeoutError)
//                            Toast.makeText(
//                                context!!,
//                                "Connection Timed Out",
//                                Toast.LENGTH_SHORT
//                            ).show()
//                        else if (error is NetworkError)
//                            Toast.makeText(
//                                context!!,
//                                "Bad Network Connection",
//                                Toast.LENGTH_SHORT
//                            ).show()
//                    })
////       loginRequest.setTag(TAG)
//            CIApp.instance?.addToRequestQueue(loginRequest)
//
//        }

        fun saveData(
            cudtomerid: String,
            itemid: String,
            boq_amount: String,
            percentage: String,
            executed_quantity: String,
            id: String


        ) {

            // ivSubmit.visibility=View.GONE
            val loginRequest =
                RequestForSaveData(
                    cudtomerid,
                    itemid,
                    boq_amount,
                    percentage,
                    executed_quantity,
                    id,


                    Response.Listener<String> { response ->
                        // ivSubmit.visibility=View.VISIBLE
                        Log.d("ddddd", response)

                        CommonUtil.hideDilog()
                        try {
                            val json = JSONTokener(response).nextValue()
//                    val json = response
                            if (json is JSONObject) {

                                val status =
                                    if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                                val data =
                                    if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                                if (status == Constants.STATUS_SUCCESS) {

                                    Toast.makeText(context!!, data, Toast.LENGTH_SHORT).show()
                                    //  context!!.finish()

                                } else if (status == Constants.STATUS_EXCEPTION) {
                                    Toast.makeText(context!!, data, Toast.LENGTH_SHORT).show()
                                } else if (status == Constants.STATUS_FAILURE) {
                                    Toast.makeText(context!!, data, Toast.LENGTH_SHORT).show()

                                }
                            } else {
                                Toast.makeText(
                                    context!!,
                                    R.string.someting_went_wrong,
                                    Toast.LENGTH_SHORT
                                ).show()
                            }
                        } catch (e: JSONException) {
                            e.printStackTrace()
                            Toast.makeText(
                                context!!,
                                R.string.someting_went_wrong,
                                Toast.LENGTH_SHORT
                            ).show()
                        }
                    },
                    Response.ErrorListener { error ->
                        // ivSubmit.visibility=View.VISIBLE

                        if (error is ServerError)
                            Toast.makeText(context!!, "Server Error", Toast.LENGTH_SHORT).show()
                        else if (error is TimeoutError)
                            Toast.makeText(
                                context!!,
                                "Connection Timed Out",
                                Toast.LENGTH_SHORT
                            ).show()
                        else if (error is NetworkError)
                            Toast.makeText(
                                context!!,
                                "Bad Network Connection",
                                Toast.LENGTH_SHORT
                            ).show()
                    })
//        loginRequest.setTag(TAG)
            CIApp.instance?.addToRequestQueue(loginRequest)


        }

    }

    /* fun onRefresh() {
         Handler().postDelayed(Runnable { refresh.setRefreshing(false) }, 5000)
     }*/
}


