package com.prrsoft.methodex.ui.signup

import android.arch.lifecycle.ViewModelProvider
import com.prrsoft.methodex.ViewModelProviderFactory
import com.prrsoft.methodex.util.SchedulerProvider
import dagger.Module
import dagger.Provides
import io.reactivex.disposables.CompositeDisposable

@Module
class SignUpActivityModule {

    @Provides
    internal fun signupViewModelProvider(signUpViewModel: SignUpViewModel): ViewModelProvider.Factory =
        ViewModelProviderFactory(signUpViewModel)


    @Provides
    internal fun provideSignUpViewModel(schedulerProvider: SchedulerProvider, compositeDisposable: CompositeDisposable): SignUpViewModel =
        SignUpViewModel( schedulerProvider,compositeDisposable)
}