package com.prrsoft.methodex.ui.signup

import android.arch.lifecycle.ViewModelProvider
import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import com.prrsoft.methodex.BR
import com.prrsoft.methodex.R

import com.prrsoft.methodex.databinding.ActivitySignUpBinding
import com.prrsoft.methodex.ui.base.mvvm.BaseActivity
import javax.inject.Inject

class SignUpActivity : BaseActivity<ActivitySignUpBinding, SignUpViewModel>(), SignUpNavigator {


    @Inject
    internal lateinit var mViewModelFactory: ViewModelProvider.Factory
    private var mActivitySignupBinding: ActivitySignUpBinding? = null
    private var mSignUpViewModel: SignUpViewModel? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mActivitySignupBinding = getViewDataBinding()
        mSignUpViewModel?.setNavigator(this)
    }


    override fun getViewModel(): SignUpViewModel {
        mSignUpViewModel = ViewModelProviders.of(this, mViewModelFactory).get(SignUpViewModel::class.java)
        return mSignUpViewModel as SignUpViewModel
    }

    override fun getBindingVariable(): Int {

    return BR.viewModel
    }

    override fun getLayoutId(): Int {
        return R.layout.activity_sign_up
    }
}
