package com.prrsoft.methodex.ui.privacypoloicy

import android.arch.lifecycle.ViewModelProvider
import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import com.prrsoft.methodex.BR
import com.prrsoft.methodex.R
import com.prrsoft.methodex.databinding.ActivityPrivacyPolicyBinding
import com.prrsoft.methodex.ui.base.mvvm.BaseActivity
import javax.inject.Inject

class PrivacyPolicyActivity : BaseActivity<ActivityPrivacyPolicyBinding, PrivacyPloicyViewModel>(), PrivacyPolicyNavigator {

    @Inject
    internal lateinit var mViewModelFactory: ViewModelProvider.Factory
    private var mActivityPrivacyPolicyBinding: ActivityPrivacyPolicyBinding? = null
    private var mPrivacyPloicyViewModel: PrivacyPloicyViewModel? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mActivityPrivacyPolicyBinding = getViewDataBinding()
        mPrivacyPloicyViewModel?.setNavigator(this)
    }

    override fun getViewModel(): PrivacyPloicyViewModel {
        mPrivacyPloicyViewModel = ViewModelProviders.of(this, mViewModelFactory).get(PrivacyPloicyViewModel::class.java)
        return mPrivacyPloicyViewModel as PrivacyPloicyViewModel
    }

    override fun getBindingVariable(): Int {

        return BR.viewModel
    }

    override fun getLayoutId(): Int {

        return R.layout.activity_privacy_policy
    }

}
