package com.prrsoft.methodex.ui.main

import android.app.Activity
import android.content.Intent
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.prrsoft.methodex.R
import com.prrsoft.methodex.ui.item.ItemListActivity
import com.prrsoft.methodex.ui.item.ItemListNavigator
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.single_project_list.view.*

class MainListAdapter(
    private val context: Activity? = null,
    private val tipsDataListArray: ArrayList<MainDataList>,
    private val recyclerView: RecyclerView,
    private val llError: LinearLayout
) :
    RecyclerView.Adapter<MainListAdapter.HomeViewHolder>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HomeViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.single_project_list, parent, false)
        return HomeViewHolder(view)
    }

    override fun getItemCount(): Int {
        if (tipsDataListArray.size == 0) {
            llError.visibility = View.VISIBLE
            return 0
        }
        if (tipsDataListArray[0].data?.size == null) {
            llError.visibility = View.VISIBLE
            return 0
        }
        llError.visibility = View.GONE
        return tipsDataListArray[0].data!!.size
    }


    override fun onBindViewHolder(holder: HomeViewHolder, position: Int) {
        tipsDataListArray[0].data?.get(position)?.let { holder.bind(it) }
    }

    inner class HomeViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        fun bind(tipsList: DATum) = with(itemView) {


            tvTital.text =
                tipsList.customerName

            setOnClickListener {


                PreferenceStore.getPreference(context).putString("CUST_ID", "" + tipsList.id)
                PreferenceStore.getPreference(context).putString("CUST_ID", "" + tipsList.projectid)

                val intent = Intent(context, ItemListActivity::class.java)
                intent.putExtra("CUSTMER_NAME", tipsList.customerName)
                intent.putExtra("ID", tipsList.id)
                intent.putExtra("PROJECT_ID", tipsList.projectid)
                intent.putExtra("CUSTMER_CARD", tipsList.customerCard)
                intent.putExtra("PP_NO", tipsList.ppNo)
                intent.putExtra("BOOKING_VOG", tipsList.bookingVOG)
                intent.putExtra("BOOKING_BRANCH", tipsList.bookingBranch)
                intent.putExtra("EX_BRANCH", tipsList.executingBranch)
                intent.putExtra("LOCATION", tipsList.location)
                intent.putExtra("PROJECT_MANAGER", tipsList.projectManager)
                intent.putExtra("SUPER_VISOR", "")

                context.startActivity(intent)


            }


        }
    }


}


