package com.prrsoft.methodex.ui.login

import android.arch.lifecycle.ViewModelProvider
import android.arch.lifecycle.ViewModelProviders
import android.content.Intent
import android.os.Bundle
import com.prrsoft.methodex.BR
import com.prrsoft.methodex.R
import com.prrsoft.methodex.databinding.ActivityLoginScreenBinding
import com.prrsoft.methodex.ui.base.mvvm.BaseActivity
import com.prrsoft.methodex.ui.main.MainActivity
import com.prrsoft.methodex.ui.otpveryfy.VeryFyOtpActivity
import kotlinx.android.synthetic.main.activity_login_screen.*
import javax.inject.Inject

class LoginScreenActivity : BaseActivity<ActivityLoginScreenBinding, LoginViewModel>(), LoginNavigator {


    @Inject
    internal lateinit var mViewModelFactory: ViewModelProvider.Factory
    private var mActivityLoginScreenBinding: ActivityLoginScreenBinding? = null
    private var mLoginViewModel: LoginViewModel? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mActivityLoginScreenBinding = getViewDataBinding()
        mLoginViewModel?.setNavigator(this)
    }

    override fun getViewModel(): LoginViewModel {

        mLoginViewModel = ViewModelProviders.of(this, mViewModelFactory).get(LoginViewModel::class.java)
        return mLoginViewModel as LoginViewModel
    }

    override fun getBindingVariable(): Int {
        return BR.viewModel;
    }

    override fun getLayoutId(): Int {
        return R.layout.activity_login_screen;
    }


    override fun clickButton() {
        if (etPhone.text.toString().trim().equals("")) {
            etPhone.setError("Please Enter User Name")
            return
        }
        if (etPassword.text.toString().trim().length == 0) {
            etPassword.setError("Please Enter Password")
            return
        }
//        if (etPassword.text.toString().trim().length < 6) {
//            etPassword.setError("Please Enter Valid Password")
//            return
//        }
        mLoginViewModel?.userLoginWs(etPhone.text.toString().trim(), etPassword.text.toString().trim(),this)

    }

    override fun openHomePage() {

        startActivity(Intent(this, MainActivity::class.java))
    }

    override fun openOtpScreen(otp: String, otpID: String) {

        val intent = Intent(this, VeryFyOtpActivity::class.java)
        intent.putExtra("OTP_ID", otpID)
        startActivity(intent)
    }

}
