package com.prrsoft.methodex.ui.login

import android.arch.lifecycle.ViewModelProvider
import com.prrsoft.methodex.ViewModelProviderFactory
import com.prrsoft.methodex.util.SchedulerProvider
import dagger.Module
import dagger.Provides
import io.reactivex.disposables.CompositeDisposable

@Module
class LoginActivityModule {

    @Provides
    internal fun loginViewModelProvider(loginViewModel: LoginViewModel): ViewModelProvider.Factory =
        ViewModelProviderFactory(loginViewModel)


    @Provides
    internal fun provideLoginViewModel(schedulerProvider: SchedulerProvider, compositeDisposable: CompositeDisposable): LoginViewModel =
        LoginViewModel( schedulerProvider,compositeDisposable)
}