package com.prrsoft.methodex.ui.item

import android.app.Activity
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.prrsoft.methodex.R
import kotlinx.android.synthetic.main.activity_item_list.view.*
import kotlinx.android.synthetic.main.item_summary.view.*

class ItemListSummaryAdapter(
    private val context: Activity? = null,
    private val tipsDataListArray: ArrayList<ITEMSUMMARY>,
    private val recyclerView: RecyclerView,
    private val llError: LinearLayout
) :
    RecyclerView.Adapter<ItemListSummaryAdapter.HomeViewHolder>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HomeViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.item_summary, parent, false)
        return HomeViewHolder(view)
    }

    override fun getItemCount(): Int {
        if (tipsDataListArray.size == 0) {
            llError.visibility = View.VISIBLE
            return 0
        }
        if (tipsDataListArray[0].data?.size == null) {
            llError.visibility = View.VISIBLE
            return 0
        }
        llError.visibility = View.GONE
        return tipsDataListArray[0].data!!.size
    }


    override fun onBindViewHolder(holder: HomeViewHolder, position: Int) {
        tipsDataListArray[0].data?.get(position)?.let { holder.bind(it) }
    }

    inner class HomeViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        fun bind(itmeList: DataItem) = with(itemView) {


            txt_categrynameitem .text = itmeList.catName
            txt_bqtamntitem.text = itmeList.boqsum
            txt_executeamntitem.text = itmeList.executedsum
            txt_percentageitem.text = itmeList.totalPercentage.toString()

         /*   setOnClickListener {

                PreferenceStore.getPreference(context).putString("ITEM_NAME", "" + itmeList.itemName)
                PreferenceStore.getPreference(context).putString("ITEM_IDDD", "" + itmeList.itemId)
                val intent = Intent(context, SpecificationListActivity::class.java)
                intent.putExtra("ID", itmeList.itemId)
                intent.putExtra("NAME", itmeList.itemName)

                context.startActivity(intent)

            }*/


        }
    }


}


