package com.prrsoft.methodex.ui.item

import android.app.Activity
import android.content.Intent
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.prrsoft.methodex.R
import com.prrsoft.methodex.ui.specificationlist.SpecificationListActivity
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.single_project_list.view.*

class ItemListProjectAdapter(
    private val context: Activity? = null,
    private val tipsDataListArray: ArrayList<ItemListDataProject>,
    private val recyclerView: RecyclerView,
    private val llError: LinearLayout
) :
    RecyclerView.Adapter<ItemListProjectAdapter.HomeViewHolder>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HomeViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.single_project_list_item, parent, false)
        return HomeViewHolder(view)
    }

    override fun getItemCount(): Int {
        if (tipsDataListArray.size == 0) {
            llError.visibility = View.VISIBLE
            return 0
        }
        if (tipsDataListArray[0].itemdatalist?.size == null) {
            llError.visibility = View.VISIBLE
            return 0
        }
        llError.visibility = View.GONE
        return tipsDataListArray[0].itemdatalist!!.size
    }


    override fun onBindViewHolder(holder: HomeViewHolder, position: Int) {
        tipsDataListArray[0].itemdatalist?.get(position)?.let { holder.bind(it) }
    }

    inner class HomeViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        fun bind(itmeList: ITEMDATALIST) = with(itemView) {


            tvTital.text = itmeList.itemName

            setOnClickListener {

                PreferenceStore.getPreference(context).putString("ITEM_NAME", "" + itmeList.itemName)
                PreferenceStore.getPreference(context).putString("ITEM_IDDD", "" + itmeList.itemId)
                val intent = Intent(context, SpecificationListActivity::class.java)
                intent.putExtra("ID", itmeList.itemId)
                intent.putExtra("NAME", itmeList.itemName)

                context.startActivity(intent)

            }


        }
    }


}


