package com.prrsoft.methodex.ui.fragment.topnews

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup

import com.prrsoft.methodex.R
import com.prrsoft.methodex.util.Constants.Companion.KEY_USER_ID_PREF
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.top_news_fragment.*

class TopNewsFragment : Fragment() {

    companion object {
        val TAG = TopNewsFragment::class.java.simpleName
        fun newInstance() = TopNewsFragment()
    }

    private lateinit var newsDataListArray: java.util.ArrayList<NewsDataListModel>
    private lateinit var viewModel: TopNewsViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.top_news_fragment, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProviders.of(this).get(TopNewsViewModel::class.java)

        newsDataListArray = ArrayList<NewsDataListModel>()
        viewModel.getNewsList(
            activity,
            PreferenceStore.getPreference(activity!!).getString(KEY_USER_ID_PREF),
            newsDataListArray,
            recyclerView,
            R.id.frameContainer,
            childFragmentManager
        )

    }

}
