package com.prrsoft.methodex.ui.fragment.newsDetailsFragment

import android.arch.lifecycle.ViewModel;
import android.support.v4.app.FragmentActivity
import android.widget.ImageView
import android.widget.TextView
import android.widget.Toast
import com.android.volley.NetworkError
import com.android.volley.Response
import com.android.volley.ServerError
import com.android.volley.TimeoutError
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.prrsoft.methodex.CIApp
import com.prrsoft.methodex.R
import com.prrsoft.methodex.network.RequestForNewsDetails
import com.prrsoft.methodex.util.CommonUtil
import com.prrsoft.methodex.util.Constants
import com.prrsoft.methodex.util.Constants.Companion.BASE_IMAGE_URL
import org.json.JSONException
import org.json.JSONObject
import org.json.JSONTokener

class NewsDetailsViewModel : ViewModel() {

    fun getNewsDetails(
        activity: FragmentActivity?,
        tvNeawsHeading: TextView?,
        tvNewsContent: TextView?,
        ivImage: ImageView?,
        newsId: String
    ) {


        CommonUtil.showLoadingDialog(activity)
        val loginRequest = RequestForNewsDetails(newsId,
            Response.Listener<String> { response ->

                CommonUtil.hideDilog()
                try {
                    val json = JSONTokener(response).nextValue()
//                    val json = response
                    if (json is JSONObject) {

                        val status = if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                        val data = if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                        if (status == Constants.STATUS_SUCCESS) {


                            val newsId = json.getJSONArray("news_list").getJSONObject(0).optString("id")
                            val headline = json.getJSONArray("news_list").getJSONObject(0).optString("headline")
                            val news = json.getJSONArray("news_list").getJSONObject(0).optString("news")
                            val name = json.getJSONArray("news_list").getJSONObject(0).optString("name")
                            val date = json.getJSONArray("news_list").getJSONObject(0).optString("date")
                            val time = json.getJSONArray("news_list").getJSONObject(0).optString("time")
                            val image = json.getJSONArray("news_list").getJSONObject(0).optString("image")

                            val requestOptions = RequestOptions()
                            requestOptions.placeholder(R.drawable.logo)
                            if (ivImage != null) {
                                Glide.with(activity!!)
                                    .load(BASE_IMAGE_URL + image)
                                    .apply(requestOptions)
                                    .into(ivImage)
                            }
                            tvNeawsHeading?.setText(headline)
                            tvNewsContent?.setText(news)


                        } else if (status == Constants.STATUS_EXCEPTION) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                        } else if (status == Constants.STATUS_FAILURE) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                        }
                    } else {
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                    Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                }
            },
            Response.ErrorListener { error ->
                CommonUtil.hideDilog()
                if (error is ServerError)
                    Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                else if (error is TimeoutError)
                    Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                else if (error is NetworkError)
                    Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
            })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)

    }
}
