package com.prrsoft.methodex.ui.fragment.home

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Toast

import com.prrsoft.methodex.R
import com.prrsoft.methodex.ui.fragment.bossTips.BossTipsFragment
import com.prrsoft.methodex.ui.fragment.bosstipsplan.BossTipsPlanFragment
import com.prrsoft.methodex.ui.fragment.freetips.FreeTipsFragment
import com.prrsoft.methodex.ui.fragment.winsubscription.WinSubscriptionFragment
import com.prrsoft.methodex.ui.main.MainActivity
import com.prrsoft.methodex.util.Constants.Companion.PAID_STATUS
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.home_fragment.*
import kotlinx.android.synthetic.main.tool_bar_layout.*

class HomeFragment : Fragment(), HomeNavigator {


    companion object {
        val TAG = HomeFragment::class.java.simpleName
        fun newInstance() = HomeFragment()
    }

    private lateinit var viewModel: HomeViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.home_fragment, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProviders.of(this).get(HomeViewModel::class.java)

        setonClickLitnerFrag(viewModel)

        viewModel.getTopTips(activity, tvCEDate, tvBuyRange, tvQuantity, tvInvestment, tvCellPrice)
    }

    private fun setonClickLitnerFrag(viewModel: HomeViewModel) {

        ivBossTips.setOnClickListener {

            if (PreferenceStore.getPreference(activity!!).getString(PAID_STATUS).equals("free")) {

                (activity as MainActivity).toolbar_title.setText("Boss Tips - F &amp; O")
                viewModel.loadFragment(
                    childFragmentManager,
                    R.id.frameContainerh,
                    BossTipsPlanFragment.newInstance(),
                    BossTipsPlanFragment.TAG
                )

            } else {
                (activity as MainActivity).toolbar_title.setText("Boss Tips - F&amp;O(Paid User)")
                viewModel.loadFragment(
                    childFragmentManager,
                    R.id.frameContainerh,
                    BossTipsFragment.newInstance(),
                    BossTipsFragment.TAG
                )
            }


        }
        ivFreeTips.setOnClickListener {
            (activity as MainActivity).toolbar_title.setText("Free Tips")
            viewModel.loadFragment(
                childFragmentManager,
                R.id.frameContainerh,
                FreeTipsFragment.newInstance(),
                FreeTipsFragment.TAG
            )
        }

        ivWinSubscription.setOnClickListener {
            (activity as MainActivity).toolbar_title.setText("Win Free Subscription")
            viewModel.loadFragment(
                childFragmentManager,
                R.id.frameContainerh,
                WinSubscriptionFragment.newInstance(),
                WinSubscriptionFragment.TAG
            )

        }
    }


    override fun openFreeTips() {

        Toast.makeText(activity, "Home Fragmnegt", Toast.LENGTH_SHORT).show()

    }

    override fun openBossTips() {


    }

}
