package com.prrsoft.methodex.ui.fragment.bossTips

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup

import com.prrsoft.methodex.R
import com.prrsoft.methodex.util.Constants.Companion.KEY_USER_ID_PREF
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.boss_tips_fragment.*

class BossTipsFragment : Fragment() {

    companion object {
        val TAG = BossTipsFragment::class.java.simpleName
        fun newInstance() = BossTipsFragment()
    }

    private lateinit var bossTipsListArray: java.util.ArrayList<TipsDataList>
    private lateinit var viewModel: BossTipsViewModel

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.boss_tips_fragment, container, false)
    }

    override fun onActivityCreated(savedInstanceState: Bundle?) {
        super.onActivityCreated(savedInstanceState)
        viewModel = ViewModelProviders.of(this).get(BossTipsViewModel::class.java)

        bossTipsListArray = ArrayList<TipsDataList>()

        viewModel.getTipsListData(
            activity,
            PreferenceStore.getPreference(activity!!).getString(KEY_USER_ID_PREF),
            bossTipsListArray,
            recyclerView,
            R.id.frameContainer,
            childFragmentManager,llError
        )
    }

}
