package com.prrsoft.methodex.ui.about

import android.arch.lifecycle.ViewModelProvider
import com.prrsoft.methodex.ViewModelProviderFactory
import com.prrsoft.methodex.util.SchedulerProvider
import dagger.Module
import dagger.Provides
import io.reactivex.disposables.CompositeDisposable

@Module
class AboutActivityModule {

    @Provides
    internal fun aboutViewModelProvider(aboutViewModel: AboutViewModel): ViewModelProvider.Factory =
        ViewModelProviderFactory(aboutViewModel)


    @Provides
    internal fun provideAboutViewModel(schedulerProvider: SchedulerProvider, compositeDisposable: CompositeDisposable): AboutViewModel =
        AboutViewModel( schedulerProvider,compositeDisposable)
}