package com.prrsoft.methodex.ui.about

import android.arch.lifecycle.ViewModelProvider
import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import com.prrsoft.methodex.BR
import com.prrsoft.methodex.R
import com.prrsoft.methodex.databinding.ActivityAboutBinding
import com.prrsoft.methodex.ui.base.mvvm.BaseActivity
import javax.inject.Inject

class AboutActivity : BaseActivity<ActivityAboutBinding, AboutViewModel>(), AboutNavigator {


    @Inject
    internal lateinit var mViewModelFactory: ViewModelProvider.Factory
    private var mActivityAboutBinding: ActivityAboutBinding? = null
    private var mAboutViewModel: AboutViewModel? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mActivityAboutBinding = getViewDataBinding()
        mAboutViewModel?.setNavigator(this)
    }

    override fun getViewModel(): AboutViewModel {
        mAboutViewModel = ViewModelProviders.of(this, mViewModelFactory).get(AboutViewModel::class.java)
        return mAboutViewModel as AboutViewModel
    }

    override fun getBindingVariable(): Int {
        return BR.viewModel
    }

    override fun getLayoutId(): Int {
        return R.layout.activity_about
    }

}
