package com.prrsoft.methodex.di.builder

import com.prrsoft.methodex.ui.about.AboutActivity
import com.prrsoft.methodex.ui.about.AboutActivityModule
import com.prrsoft.methodex.ui.item.ItemListActivity
import com.prrsoft.methodex.ui.item.ItemViewModule
import com.prrsoft.methodex.ui.login.LoginActivityModule
import com.prrsoft.methodex.ui.login.LoginScreenActivity
import com.prrsoft.methodex.ui.main.MainActivity
import com.prrsoft.methodex.ui.main.MainActivityModule
import com.prrsoft.methodex.ui.otpveryfy.VeryFyOtpActivity
import com.prrsoft.methodex.ui.otpveryfy.VeryFyViewModule
import com.prrsoft.methodex.ui.privacypoloicy.PrivacyPolicyActivity
import com.prrsoft.methodex.ui.privacypoloicy.PrivacyPolicyActivityModule
import com.prrsoft.methodex.ui.signup.SignUpActivity
import com.prrsoft.methodex.ui.signup.SignUpActivityModule

import com.prrsoft.methodex.ui.specificationlist.SpecificationListActivity
import com.prrsoft.methodex.ui.specificationlist.SpecificatrionListModule
import com.prrsoft.methodex.ui.splash.SplashActivityModule
import com.prrsoft.methodex.ui.splash.SplashScreenActivity
import dagger.Module
import dagger.android.ContributesAndroidInjector

@Module
abstract class ActivityBuilder {

    @ContributesAndroidInjector(modules = [(MainActivityModule::class)])
    abstract fun bindMainActivity(): MainActivity

    @ContributesAndroidInjector(modules = [(SplashActivityModule::class)])
    abstract fun bindSplashActivity(): SplashScreenActivity

    @ContributesAndroidInjector(modules = [(LoginActivityModule::class)])
    abstract fun bindLoginScreenActivity(): LoginScreenActivity

    @ContributesAndroidInjector(modules = [(SignUpActivityModule::class)])
    abstract fun bindSignUpActivity(): SignUpActivity

    @ContributesAndroidInjector(modules = [(AboutActivityModule::class)])
    abstract fun bindAboutActivity(): AboutActivity

    @ContributesAndroidInjector(modules = [(PrivacyPolicyActivityModule::class)])
    abstract fun bindPrivacyPolicyActivity(): PrivacyPolicyActivity

    @ContributesAndroidInjector(modules = [(VeryFyViewModule::class)])
    abstract fun bindVeryFyOtpActivity(): VeryFyOtpActivity

    @ContributesAndroidInjector(modules = [(ItemViewModule::class)])
    abstract fun bindItemListActivity(): ItemListActivity

    @ContributesAndroidInjector(modules = [(SpecificatrionListModule::class)])
    abstract fun bindSpecificationListActivity(): SpecificationListActivity
/*
    @ContributesAndroidInjector(modules = [(SpeficationFieldModule::class)])
    abstract fun bindSpeficationFieldActivity(): SpeficationFieldActivity*/


}