package com.prrsoft.methodex.di.builder;

import android.app.Activity;
import com.prrsoft.methodex.ui.item.ItemListActivity;
import com.prrsoft.methodex.ui.item.ItemViewModule;
import dagger.Binds;
import dagger.Module;
import dagger.Subcomponent;
import dagger.android.ActivityKey;
import dagger.android.AndroidInjector;
import dagger.multibindings.IntoMap;

@Module(subcomponents = ActivityBuilder_BindItemListActivity.ItemListActivitySubcomponent.class)
public abstract class ActivityBuilder_BindItemListActivity {
  private ActivityBuilder_BindItemListActivity() {}

  @Binds
  @IntoMap
  @ActivityKey(ItemListActivity.class)
  abstract AndroidInjector.Factory<? extends Activity> bindAndroidInjectorFactory(
      ItemListActivitySubcomponent.Builder builder);

  @Subcomponent(modules = ItemViewModule.class)
  public interface ItemListActivitySubcomponent extends AndroidInjector<ItemListActivity> {
    @Subcomponent.Builder
    abstract class Builder extends AndroidInjector.Builder<ItemListActivity> {}
  }
}
