package com.prrsoft.methodex.databinding;

import android.databinding.Bindable;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.widget.SwipeRefreshLayout;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.prrsoft.methodex.ui.specificationlist.SpecificatonListViewModel;
import java.lang.Deprecated;
import java.lang.Object;

public abstract class ActivitySpecificationListBinding extends ViewDataBinding {
  @NonNull
  public final FrameLayout frameContainer;

  @NonNull
  public final LinearLayout llError;

  @NonNull
  public final RecyclerView recyclerView;

  @NonNull
  public final SwipeRefreshLayout refresh;

  @NonNull
  public final RelativeLayout relativeReception;

  @Bindable
  protected SpecificatonListViewModel mViewModel;

  protected ActivitySpecificationListBinding(Object _bindingComponent, View _root,
      int _localFieldCount, FrameLayout frameContainer, LinearLayout llError,
      RecyclerView recyclerView, SwipeRefreshLayout refresh, RelativeLayout relativeReception) {
    super(_bindingComponent, _root, _localFieldCount);
    this.frameContainer = frameContainer;
    this.llError = llError;
    this.recyclerView = recyclerView;
    this.refresh = refresh;
    this.relativeReception = relativeReception;
  }

  public abstract void setViewModel(@Nullable SpecificatonListViewModel viewModel);

  @Nullable
  public SpecificatonListViewModel getViewModel() {
    return mViewModel;
  }

  @NonNull
  public static ActivitySpecificationListBinding inflate(@NonNull LayoutInflater inflater,
      @Nullable ViewGroup root, boolean attachToRoot) {
    return inflate(inflater, root, attachToRoot, DataBindingUtil.getDefaultComponent());
  }

  /**
   * This method receives DataBindingComponent instance as type Object instead of
   * type DataBindingComponent to avoid causing too many compilation errors if
   * compilation fails for another reason.
   * https://issuetracker.google.com/issues/116541301
   * @Deprecated Use DataBindingUtil.inflate(inflater, R.layout.activity_specification_list, root, attachToRoot, component)
   */
  @NonNull
  @Deprecated
  public static ActivitySpecificationListBinding inflate(@NonNull LayoutInflater inflater,
      @Nullable ViewGroup root, boolean attachToRoot, @Nullable Object component) {
    return ViewDataBinding.<ActivitySpecificationListBinding>inflateInternal(inflater, com.prrsoft.methodex.R.layout.activity_specification_list, root, attachToRoot, component);
  }

  @NonNull
  public static ActivitySpecificationListBinding inflate(@NonNull LayoutInflater inflater) {
    return inflate(inflater, DataBindingUtil.getDefaultComponent());
  }

  /**
   * This method receives DataBindingComponent instance as type Object instead of
   * type DataBindingComponent to avoid causing too many compilation errors if
   * compilation fails for another reason.
   * https://issuetracker.google.com/issues/116541301
   * @Deprecated Use DataBindingUtil.inflate(inflater, R.layout.activity_specification_list, null, false, component)
   */
  @NonNull
  @Deprecated
  public static ActivitySpecificationListBinding inflate(@NonNull LayoutInflater inflater,
      @Nullable Object component) {
    return ViewDataBinding.<ActivitySpecificationListBinding>inflateInternal(inflater, com.prrsoft.methodex.R.layout.activity_specification_list, null, false, component);
  }

  public static ActivitySpecificationListBinding bind(@NonNull View view) {
    return bind(view, DataBindingUtil.getDefaultComponent());
  }

  /**
   * This method receives DataBindingComponent instance as type Object instead of
   * type DataBindingComponent to avoid causing too many compilation errors if
   * compilation fails for another reason.
   * https://issuetracker.google.com/issues/116541301
   * @Deprecated Use DataBindingUtil.bind(view, component)
   */
  @Deprecated
  public static ActivitySpecificationListBinding bind(@NonNull View view,
      @Nullable Object component) {
    return (ActivitySpecificationListBinding)bind(component, view, com.prrsoft.methodex.R.layout.activity_specification_list);
  }
}
