package com.prrsoft.methodex.databinding;

import android.databinding.Bindable;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.prrsoft.methodex.ui.fragment.newsDetailsFragment.NewsDetailsViewModel;
import java.lang.Deprecated;
import java.lang.Object;

public abstract class NewsDetailsFragmentBinding extends ViewDataBinding {
  @NonNull
  public final ImageView ivImage;

  @NonNull
  public final TextView tvNeawsHeading;

  @NonNull
  public final TextView tvNewsContent;

  @Bindable
  protected NewsDetailsViewModel mViewModel;

  protected NewsDetailsFragmentBinding(Object _bindingComponent, View _root, int _localFieldCount,
      ImageView ivImage, TextView tvNeawsHeading, TextView tvNewsContent) {
    super(_bindingComponent, _root, _localFieldCount);
    this.ivImage = ivImage;
    this.tvNeawsHeading = tvNeawsHeading;
    this.tvNewsContent = tvNewsContent;
  }

  public abstract void setViewModel(@Nullable NewsDetailsViewModel viewModel);

  @Nullable
  public NewsDetailsViewModel getViewModel() {
    return mViewModel;
  }

  @NonNull
  public static NewsDetailsFragmentBinding inflate(@NonNull LayoutInflater inflater,
      @Nullable ViewGroup root, boolean attachToRoot) {
    return inflate(inflater, root, attachToRoot, DataBindingUtil.getDefaultComponent());
  }

  /**
   * This method receives DataBindingComponent instance as type Object instead of
   * type DataBindingComponent to avoid causing too many compilation errors if
   * compilation fails for another reason.
   * https://issuetracker.google.com/issues/116541301
   * @Deprecated Use DataBindingUtil.inflate(inflater, R.layout.news_details_fragment, root, attachToRoot, component)
   */
  @NonNull
  @Deprecated
  public static NewsDetailsFragmentBinding inflate(@NonNull LayoutInflater inflater,
      @Nullable ViewGroup root, boolean attachToRoot, @Nullable Object component) {
    return ViewDataBinding.<NewsDetailsFragmentBinding>inflateInternal(inflater, com.prrsoft.methodex.R.layout.news_details_fragment, root, attachToRoot, component);
  }

  @NonNull
  public static NewsDetailsFragmentBinding inflate(@NonNull LayoutInflater inflater) {
    return inflate(inflater, DataBindingUtil.getDefaultComponent());
  }

  /**
   * This method receives DataBindingComponent instance as type Object instead of
   * type DataBindingComponent to avoid causing too many compilation errors if
   * compilation fails for another reason.
   * https://issuetracker.google.com/issues/116541301
   * @Deprecated Use DataBindingUtil.inflate(inflater, R.layout.news_details_fragment, null, false, component)
   */
  @NonNull
  @Deprecated
  public static NewsDetailsFragmentBinding inflate(@NonNull LayoutInflater inflater,
      @Nullable Object component) {
    return ViewDataBinding.<NewsDetailsFragmentBinding>inflateInternal(inflater, com.prrsoft.methodex.R.layout.news_details_fragment, null, false, component);
  }

  public static NewsDetailsFragmentBinding bind(@NonNull View view) {
    return bind(view, DataBindingUtil.getDefaultComponent());
  }

  /**
   * This method receives DataBindingComponent instance as type Object instead of
   * type DataBindingComponent to avoid causing too many compilation errors if
   * compilation fails for another reason.
   * https://issuetracker.google.com/issues/116541301
   * @Deprecated Use DataBindingUtil.bind(view, component)
   */
  @Deprecated
  public static NewsDetailsFragmentBinding bind(@NonNull View view, @Nullable Object component) {
    return (NewsDetailsFragmentBinding)bind(component, view, com.prrsoft.methodex.R.layout.news_details_fragment);
  }
}
