package com.prrsoft.methodex.ui.splash

import android.arch.lifecycle.ViewModelProvider
import android.arch.lifecycle.ViewModelProviders
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.os.Bundle
import android.support.v4.content.LocalBroadcastManager
import com.prrsoft.methodex.BR
import com.prrsoft.methodex.R
import com.prrsoft.methodex.databinding.ActivitySplashScreenBinding
import com.prrsoft.methodex.ui.base.mvvm.BaseActivity
import com.prrsoft.methodex.ui.login.LoginScreenActivity
import com.prrsoft.methodex.ui.main.MainActivity
import com.prrsoft.methodex.util.Constants
import com.prrsoft.visitormanagment.PreferenceStore
import javax.inject.Inject

class SplashScreenActivity : BaseActivity<ActivitySplashScreenBinding, SplashViewModel>(), SplashNavigator {


    @Inject
    internal lateinit var mViewModelFactory: ViewModelProvider.Factory
    private var mActivitySplashScreenBinding: ActivitySplashScreenBinding? = null
    private var mSplashViewModel: SplashViewModel? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mActivitySplashScreenBinding = getViewDataBinding()
        mSplashViewModel?.setNavigator(this)
        mSplashViewModel?.startActivity();


    }


    override fun getViewModel(): SplashViewModel {
        mSplashViewModel = ViewModelProviders.of(this, mViewModelFactory).get(SplashViewModel::class.java)
        return mSplashViewModel as SplashViewModel
    }

    override fun getBindingVariable(): Int {
        return BR.viewModel;
    }

    override fun getLayoutId(): Int {
        return R.layout.activity_splash_screen;
    }


    override fun openLoginActivity() {

        if (PreferenceStore.getPreference(this).getString(Constants.KEY_USER_ID_PREF).equals("")) {

            startActivity(Intent(this@SplashScreenActivity, LoginScreenActivity::class.java))
            finish()
        } else {
            startActivity(Intent(this@SplashScreenActivity, MainActivity::class.java))
            finish()
        }
    }

    override fun openMainActivity() {

        startActivity(Intent(this@SplashScreenActivity, MainActivity::class.java))
        finish()
    }
}
