package com.prrsoft.methodex.ui.splash

import android.arch.lifecycle.ViewModelProvider
import com.prrsoft.methodex.ViewModelProviderFactory
import com.prrsoft.methodex.util.SchedulerProvider
import dagger.Module
import dagger.Provides
import io.reactivex.disposables.CompositeDisposable
@Module
class SplashActivityModule {

    @Provides
    internal fun splashViewModelProvider(splashViewModel: SplashViewModel): ViewModelProvider.Factory =
        ViewModelProviderFactory(splashViewModel)


    @Provides
    internal fun provideSplashViewModel(
        schedulerProvider: SchedulerProvider,
        compositeDisposable: CompositeDisposable
    ): SplashViewModel =
        SplashViewModel(schedulerProvider, compositeDisposable)

}