package com.prrsoft.methodex.ui.specificationlist

import android.app.Activity
import android.content.Intent
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.prrsoft.methodex.R
import com.prrsoft.methodex.ui.item.ItemListActivity
import com.prrsoft.methodex.ui.specificationfield.SpeficationFieldActivity
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.single_project_list_specification.view.*

class SpecificationListAdapter(
    private val context: Activity? = null,
    private val tipsDataListArray: ArrayList<SpeficationListData>,
    private val recyclerView: RecyclerView,
    private val llError: LinearLayout
) :
    RecyclerView.Adapter<SpecificationListAdapter.HomeViewHolder>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HomeViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.single_project_list_specification, parent, false)
        return HomeViewHolder(view)
    }

    override fun getItemCount(): Int {
        if (tipsDataListArray.size == 0) {
            llError.visibility = View.VISIBLE
            return 0
        }
        if (tipsDataListArray[0].specificationdatalist?.size == null) {
            llError.visibility = View.VISIBLE
            return 0
        }
        llError.visibility = View.GONE
        return tipsDataListArray[0].specificationdatalist!!.size
    }


    override fun onBindViewHolder(holder: HomeViewHolder, position: Int) {
        tipsDataListArray[0].specificationdatalist?.get(position)?.let { holder.bind(it) }
    }

    inner class HomeViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        fun bind(tipsList: SPECIFICATIONDATALIST) = with(itemView) {


            tvTital.text =
                tipsList.specification

            setOnClickListener {


                val intent = Intent(context, SpeficationFieldActivity::class.java)
                intent.putExtra("NAME", tipsList.specification)
                intent.putExtra("ID", tipsList.id)

                PreferenceStore.getPreference(context).putString("IIID",""+tipsList.id)

                context.startActivity(intent)


            }


        }
    }


}


