package com.prrsoft.methodex.ui.specificationlist

import android.arch.lifecycle.ViewModelProvider
import android.arch.lifecycle.ViewModelProviders
import android.support.v7.app.AppCompatActivity
import android.os.Bundle
import android.support.v7.widget.Toolbar
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.prrsoft.methodex.BR
import com.prrsoft.methodex.R
import com.prrsoft.methodex.databinding.ActivitySpecificationListBinding
import com.prrsoft.methodex.ui.base.mvvm.BaseActivity
import kotlinx.android.synthetic.main.activity_specification_list.*
import javax.inject.Inject

class SpecificationListActivity : BaseActivity<ActivitySpecificationListBinding, SpecificatonListViewModel>(),
    SpecificationListNavogator {


    private lateinit var imghome: ImageView
    private lateinit var toolBarTitel: TextView
    private lateinit var mToolBar: Toolbar
    private lateinit var specificationList: java.util.ArrayList<SpeficationListData>
    @Inject
    internal lateinit var mViewModelFactory: ViewModelProvider.Factory
    private var mActivitySpecificationListBinding: ActivitySpecificationListBinding? = null
    private var mSpecificatonListViewModel: SpecificatonListViewModel? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mActivitySpecificationListBinding = getViewDataBinding()
        mSpecificatonListViewModel?.setNavigator(this)

        specificationList = ArrayList<SpeficationListData>()

        getIds(intent.getStringExtra("NAME"))
        mSpecificatonListViewModel?.getMainDataList(
            "",
            intent.getStringExtra("ID"),
            this,
            specificationList,
            recyclerView,
            llError
        )
    }

    override fun getViewModel(): SpecificatonListViewModel {
        mSpecificatonListViewModel =
            ViewModelProviders.of(this, mViewModelFactory).get(SpecificatonListViewModel::class.java)
        return mSpecificatonListViewModel as SpecificatonListViewModel
    }

    override fun getBindingVariable(): Int {
        return BR.viewModel
    }

    override fun getLayoutId(): Int {

        return R.layout.activity_specification_list
    }


    private fun getIds(name: String) {

        mToolBar = findViewById(R.id.toolbar) as Toolbar
        setUpToolbar(R.drawable.ic_arrow_back_black_24dp, name)

    }


    private fun setUpToolbar(menu: Int, titleStr: String) {

        mToolBar.setContentInsetStartWithNavigation(0)

        toolBarTitel = mToolBar.findViewById(R.id.toolbar_title) as TextView
        imghome = mToolBar.findViewById(R.id.home) as ImageView
        imghome.setImageResource(menu)
        toolBarTitel.setText(titleStr)
        mToolBar.setNavigationIcon(null)

        imghome.setOnClickListener(View.OnClickListener {
            finish()
        })


    }





}
