package com.prrsoft.methodex.ui.specificationfield

import android.app.Activity
import android.widget.EditText
import android.widget.TextView
import android.widget.Toast
import com.android.volley.NetworkError
import com.android.volley.Response
import com.android.volley.ServerError
import com.android.volley.TimeoutError
import com.google.gson.Gson
import com.prrsoft.methodex.CIApp
import com.prrsoft.methodex.R
import com.prrsoft.methodex.network.RequestForFindPercentage
import com.prrsoft.methodex.network.RequestForSaveData
import com.prrsoft.methodex.network.RequestForSpeficDetails
import com.prrsoft.methodex.ui.base.mvvm.BaseViewModel
import com.prrsoft.methodex.util.CommonUtil
import com.prrsoft.methodex.util.Constants
import com.prrsoft.methodex.util.SchedulerProvider
import com.prrsoft.visitormanagment.PreferenceStore
import io.reactivex.disposables.CompositeDisposable
import org.json.JSONException
import org.json.JSONObject
import org.json.JSONTokener
import javax.inject.Inject
import kotlin.collections.ArrayList


class SpeficationFieldViewModel @Inject internal constructor(s: SchedulerProvider, c: CompositeDisposable) :
    BaseViewModel<SpeficationFieldNavigator>(s, c) {


    fun getDetailsOfSpefication(
        activity: Activity,
        spId: String,
        title: String,
        tvTitle: TextView?,
        tvUnit: TextView?,
        tvboq: TextView?,
        etExQTY: EditText?,
        specificationList: ArrayList<SpecificationDataFieldList>
    ) {

        CommonUtil.showLoadingDialog(activity)
        val loginRequest =
            RequestForSpeficDetails(
                spId,
                Response.Listener<String> { response ->

                    CommonUtil.hideDilog()
                    try {
                        val json = JSONTokener(response).nextValue()
//                    val json = response
                        if (json is JSONObject) {

                            val status =
                                if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                            val data =
                                if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                            if (status == Constants.STATUS_SUCCESS) {


                                var mainDataList = SpecificationDataFieldList()
                                mainDataList = Gson().fromJson(response, SpecificationDataFieldList::class.java)
                                specificationList.add(mainDataList)

                                setUpUI(activity, specificationList, tvTitle, tvUnit, tvboq, etExQTY, title)


                            } else if (status == Constants.STATUS_EXCEPTION) {
                                Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                            } else if (status == Constants.STATUS_FAILURE) {
                                Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                            }
                        } else {
                            Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                },
                Response.ErrorListener { error ->
                    CommonUtil.hideDilog()
                    if (error is ServerError)
                        Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                    else if (error is TimeoutError)
                        Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                    else if (error is NetworkError)
                        Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
                })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)

    }

    private fun setUpUI(
        activity: Activity,
        specificationList: ArrayList<SpecificationDataFieldList>,
        tvTitle: TextView?,
        tvUnit: TextView?,
        tvboq: TextView?,
        etExQTY: EditText?,
        title: String
    ) {

        tvUnit!!.setText(specificationList[0].specificationfields?.get(0)?.unit)
        tvboq!!.setText(specificationList[0].specificationfields?.get(0)?.boqQty)
//        etExQTY!!.setText(specificationList[0].specificationfields?.get(0)?.executedQty)
        tvTitle!!.setText(title)

        PreferenceStore.getPreference(activity)
            .putString("boq_quantity", "" + specificationList[0].specificationfields?.get(0)?.boqQty)
        PreferenceStore.getPreference(activity)
            .putString("Weightage", "" + specificationList[0].specificationfields?.get(0)?.weightagePer)

        PreferenceStore.getPreference(activity)
            .putString("boq_amount", "" + specificationList[0].specificationfields?.get(0)?.boqAmount)

    }

    fun requestForPercentage(
        activity: Activity,
        s: String,
        specificationList: ArrayList<SpecificationDataFieldList>,
        tvPercentage: TextView?,
        id: String
    ) {


        val loginRequest =
            RequestForFindPercentage(PreferenceStore.getPreference(activity).getString("boq_quantity"),
                PreferenceStore.getPreference(activity).getString("Weightage"),
                s,
                id,
                Response.Listener<String> { response ->

                    CommonUtil.hideDilog()
                    try {
                        val json = JSONTokener(response).nextValue()
//                    val json = response
                        if (json is JSONObject) {

                            val status =
                                if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                            val data =
                                if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                            if (status == Constants.STATUS_SUCCESS) {

                                tvPercentage!!.setText(json.optString("PERCENTAGE_DATA"))

                            } else if (status == Constants.STATUS_EXCEPTION) {
                                Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                            } else if (status == Constants.STATUS_FAILURE) {
                                Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                            }
                        } else {
                            Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                },
                Response.ErrorListener { error ->
                    CommonUtil.hideDilog()
                    if (error is ServerError)
                        Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                    else if (error is TimeoutError)
                        Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                    else if (error is NetworkError)
                        Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
                })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)

    }

    fun saveData(activity: Activity, ext: String, speId: String) {

        CommonUtil.showLoadingDialog(activity)

        val loginRequest =
            RequestForSaveData(PreferenceStore.getPreference(activity).getString("CUST_ID"),
                PreferenceStore.getPreference(activity).getString("ITEM_IDDD"),
                PreferenceStore.getPreference(activity).getString("boq_quantity"),
                PreferenceStore.getPreference(activity).getString("boq_amount")
                , PreferenceStore.getPreference(activity).getString("Weightage"), ext, speId,
                Response.Listener<String> { response ->

                    CommonUtil.hideDilog()
                    try {
                        val json = JSONTokener(response).nextValue()
//                    val json = response
                        if (json is JSONObject) {

                            val status =
                                if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                            val data =
                                if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                            if (status == Constants.STATUS_SUCCESS) {

                                Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                                activity.finish()

                            } else if (status == Constants.STATUS_EXCEPTION) {
                                Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                            } else if (status == Constants.STATUS_FAILURE) {
                                Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                            }
                        } else {
                            Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                },
                Response.ErrorListener { error ->
                    CommonUtil.hideDilog()
                    if (error is ServerError)
                        Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                    else if (error is TimeoutError)
                        Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                    else if (error is NetworkError)
                        Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
                })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)


    }


}