package com.prrsoft.methodex.ui.specificationfield

import android.arch.lifecycle.ViewModelProvider
import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v7.widget.Toolbar
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.prrsoft.methodex.BR
import com.prrsoft.methodex.R
import com.prrsoft.methodex.databinding.ActivitySpeficationFieldBinding
import com.prrsoft.methodex.ui.base.mvvm.BaseActivity
import com.prrsoft.visitormanagment.PreferenceStore
import kotlinx.android.synthetic.main.activity_spefication_field.*
import javax.inject.Inject
import android.text.Editable
import android.text.TextWatcher


class SpeficationFieldActivity : BaseActivity<ActivitySpeficationFieldBinding, SpeficationFieldViewModel>(),
    SpeficationFieldNavigator {


    private lateinit var imghome: ImageView
    private lateinit var toolBarTitel: TextView
    private lateinit var mToolBar: Toolbar
    private lateinit var specificationList: ArrayList<SpecificationDataFieldList>
    @Inject
    internal lateinit var mViewModelFactory: ViewModelProvider.Factory
    private var mActivitySpeficationFieldBinding: ActivitySpeficationFieldBinding? = null
    private var mSpeficationFieldViewModel: SpeficationFieldViewModel? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        mActivitySpeficationFieldBinding = getViewDataBinding()
        mSpeficationFieldViewModel?.setNavigator(this)
        getIds(PreferenceStore.getPreference(this).getString("ITEM_NAME"))

        specificationList = ArrayList<SpecificationDataFieldList>()

        mSpeficationFieldViewModel?.getDetailsOfSpefication(
            this,
            intent.getStringExtra("ID"),
            intent.getStringExtra("NAME"),
            tvTitle,
            tvUnit,
            tvboq,
            etExQTY,
            specificationList
        )
    }

    override fun getViewModel(): SpeficationFieldViewModel {
        mSpeficationFieldViewModel =
            ViewModelProviders.of(this, mViewModelFactory).get(SpeficationFieldViewModel::class.java)
        return mSpeficationFieldViewModel as SpeficationFieldViewModel
    }

    override fun getBindingVariable(): Int {
        return BR.viewModel
    }

    override fun getLayoutId(): Int {
        return R.layout.activity_spefication_field
    }

    private fun getIds(name: String) {

        mToolBar = findViewById(R.id.toolbar) as Toolbar
        setUpToolbar(R.drawable.ic_arrow_back_black_24dp, name)

        etExQTY.addTextChangedListener(object : TextWatcher {

            override fun afterTextChanged(s: Editable) {}

            override fun beforeTextChanged(
                s: CharSequence, start: Int,
                count: Int, after: Int
            ) {

                tvPercentage.setText("")
            }

            override fun onTextChanged(
                str: CharSequence, start: Int,
                before: Int, count: Int
            ) {
                mSpeficationFieldViewModel?.requestForPercentage(
                    this@SpeficationFieldActivity,
                    str.toString(),
                    specificationList,
                    tvPercentage,
                    PreferenceStore.getPreference(this@SpeficationFieldActivity).getString("IIID")
                )
            }
        })

        ivSubmit.setOnClickListener {

            mSpeficationFieldViewModel?.saveData(this,etExQTY.text.toString().trim(),PreferenceStore.getPreference(this@SpeficationFieldActivity).getString("IIID"))

        }
    }


    private fun setUpToolbar(menu: Int, titleStr: String) {

        mToolBar.setContentInsetStartWithNavigation(0)

        toolBarTitel = mToolBar.findViewById(R.id.toolbar_title) as TextView
        imghome = mToolBar.findViewById(R.id.home) as ImageView
        imghome.setImageResource(menu)
        toolBarTitel.setText(titleStr)
        mToolBar.setNavigationIcon(null)

        imghome.setOnClickListener(View.OnClickListener {
            finish()
        })


    }

}
