package com.prrsoft.methodex.ui.otpveryfy

import android.widget.Toast
import com.android.volley.NetworkError
import com.android.volley.Response
import com.android.volley.ServerError
import com.android.volley.TimeoutError
import com.prrsoft.methodex.CIApp
import com.prrsoft.methodex.R
import com.prrsoft.methodex.network.MatchOtpRequest
import com.prrsoft.methodex.ui.base.mvvm.BaseViewModel
import com.prrsoft.methodex.util.CommonUtil
import com.prrsoft.methodex.util.Constants
import com.prrsoft.methodex.util.Constants.Companion.COUPON_CODE
import com.prrsoft.methodex.util.Constants.Companion.COUPON_OFFER
import com.prrsoft.methodex.util.Constants.Companion.KEY_MOBILE_NUMBER
import com.prrsoft.methodex.util.Constants.Companion.KEY_USER_ID_PREF
import com.prrsoft.methodex.util.Constants.Companion.PAID_STATUS
import com.prrsoft.methodex.util.Constants.Companion.USER_TYPE
import com.prrsoft.methodex.util.SchedulerProvider
import com.prrsoft.visitormanagment.PreferenceStore
import io.reactivex.disposables.CompositeDisposable
import org.json.JSONException
import org.json.JSONObject
import org.json.JSONTokener
import javax.inject.Inject

class VeryFyViewModel @Inject internal constructor(s: SchedulerProvider, c: CompositeDisposable) :
    BaseViewModel<VeryFyNavigator>(s, c) {

    fun startActivity() {

        getNavigator()?.openEditTextChangeListner()
    }

    fun submitButton() {

        getNavigator()?.clickButton()
    }


    fun otpMatchRequest(otpId: String, otp: String, activity: VeryFyOtpActivity) {

        CommonUtil.showLoadingDialog(activity)

        val requestForotp = MatchOtpRequest(
            otp,
            otpId,
            Response.Listener<String> { response ->
                CommonUtil.hideDilog()

                try {
                    val json = JSONTokener(response).nextValue()
                    if (json is JSONObject) {

                        val status = if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                        val data = if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                        if (status == Constants.STATUS_SUCCESS) {
                            val id = json.getJSONObject("USER_DATA").optString("userid")
                            val phone = json.getJSONObject("USER_DATA").optString("usermobile")
                            val PAID_STATUSs = json.optString("PAID_STATUS")
                            val USER_TYPEs = json.optString("USER_TYPE")
                            val COUPON_CODEs = json.optString("COUPON_CODE")
                            val COUPON_OFFERs = json.optString("COUPON_OFFER")

                            PreferenceStore.getPreference(activity).putString(KEY_MOBILE_NUMBER, phone)
                            PreferenceStore.getPreference(activity).putString(KEY_USER_ID_PREF, id)
                            PreferenceStore.getPreference(activity).putString(PAID_STATUS, PAID_STATUSs)
                            PreferenceStore.getPreference(activity).putString(USER_TYPE, USER_TYPEs)
                            PreferenceStore.getPreference(activity).putString(COUPON_CODE, COUPON_CODEs)
                            PreferenceStore.getPreference(activity).putString(COUPON_OFFER, COUPON_OFFERs)
                            getNavigator()?.openHomePage()
                            activity.finish()

                        } else if (status == Constants.STATUS_EXCEPTION) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                        } else if (status == Constants.STATUS_FAILURE) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                        }
                    } else {
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                    Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                }
            },
            Response.ErrorListener { error ->
                CommonUtil.hideDilog()
                if (error is ServerError)
                    Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                else if (error is TimeoutError)
                    Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                else if (error is NetworkError)
                    Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
            })

        CIApp.instance?.addToRequestQueue(requestForotp)

    }


}