package com.prrsoft.methodex.ui.login

import android.app.Activity
import android.widget.Toast
import com.android.volley.NetworkError
import com.android.volley.Response
import com.android.volley.ServerError
import com.android.volley.TimeoutError
import com.prrsoft.methodex.CIApp
import com.prrsoft.methodex.R
import com.prrsoft.methodex.network.LoginRequest
import com.prrsoft.methodex.ui.base.mvvm.BaseViewModel
import com.prrsoft.methodex.util.CommonUtil
import com.prrsoft.methodex.util.Constants
import com.prrsoft.methodex.util.Constants.Companion.KEY_EMAIL
import com.prrsoft.methodex.util.Constants.Companion.KEY_RESPONSE
import com.prrsoft.methodex.util.Constants.Companion.KEY_STATUS
import com.prrsoft.methodex.util.Constants.Companion.KEY_USER_ID_PREF
import com.prrsoft.methodex.util.Constants.Companion.STATUS_EXCEPTION
import com.prrsoft.methodex.util.Constants.Companion.STATUS_FAILURE
import com.prrsoft.methodex.util.Constants.Companion.STATUS_SUCCESS
import com.prrsoft.methodex.util.SchedulerProvider
import com.prrsoft.visitormanagment.PreferenceStore
import io.reactivex.disposables.CompositeDisposable
import org.json.JSONException
import org.json.JSONObject
import org.json.JSONTokener
import javax.inject.Inject

class LoginViewModel @Inject internal constructor(
    schedulerProvider: SchedulerProvider,
    compositeDisposable: CompositeDisposable
) : BaseViewModel<LoginNavigator>(schedulerProvider, compositeDisposable) {


    fun submitButton() {
        getNavigator()?.clickButton()
    }


    fun userLoginWs(phone: String, password: String, activity: Activity) {
        CommonUtil.showLoadingDialog(activity)
        val loginRequest = LoginRequest(
            phone,password,
            Response.Listener<String> { response ->

                CommonUtil.hideDilog()
                try {
                    val json = JSONTokener(response).nextValue()
//                    val json = response
                    if (json is JSONObject) {

                        val status = if (json.has(KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                        val data = if (json.has(KEY_RESPONSE)) json.getString(KEY_RESPONSE) else ""
                        if (status == STATUS_SUCCESS) {


                            val id = json.getJSONObject("DATA").optString("id")
                            val email = json.getJSONObject("DATA").optString("email")
                            val password = json.getJSONObject("DATA").optString("password")
                            val is_active = json.getJSONObject("DATA").optString("is_active")


                            PreferenceStore.getPreference(activity).putString(KEY_USER_ID_PREF, id)
                            PreferenceStore.getPreference(activity).putString(KEY_EMAIL, email)
                            getNavigator()?.openHomePage()

                            activity.finish()


                        } else if (status == STATUS_EXCEPTION) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                        } else if (status == STATUS_FAILURE) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                        }
                    } else {
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                    Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                }
            },
            Response.ErrorListener
            { error ->
                CommonUtil.hideDilog()
                if (error is ServerError)
                    Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                else if (error is TimeoutError)
                    Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                else if (error is NetworkError)
                    Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
            })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)

    }

}