package com.prrsoft.methodex.ui.item

import android.arch.lifecycle.ViewModelProvider
import android.arch.lifecycle.ViewModelProviders
import android.support.v7.app.AppCompatActivity
import android.os.Bundle
import android.support.v4.widget.DrawerLayout
import android.support.v7.widget.Toolbar
import android.view.Gravity
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import com.prrsoft.methodex.BR
import com.prrsoft.methodex.R
import com.prrsoft.methodex.databinding.ActivityItemListBinding
import com.prrsoft.methodex.ui.base.mvvm.BaseActivity
import kotlinx.android.synthetic.main.activity_item_list.*
import javax.inject.Inject

class ItemListActivity : BaseActivity<ActivityItemListBinding, ItmViewModel>(), ItemListNavigator {

    private lateinit var imghome: ImageView
    private lateinit var toolBarTitel: TextView
    private lateinit var mToolBar: Toolbar
    private lateinit var arrayList: ArrayList<ItemListDataProject>
    @Inject
    internal lateinit var mViewModelFactory: ViewModelProvider.Factory
    private var mActivityItemListBinding: ActivityItemListBinding? = null
    private var mItmViewModel: ItmViewModel? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mActivityItemListBinding = getViewDataBinding()
        mItmViewModel?.setNavigator(this)
        getIds(intent.getStringExtra("CUSTMER_NAME"))
        setUi(
            intent.getStringExtra("CUSTMER_NAME"),
            intent.getStringExtra("CUSTMER_CARD"),
            intent.getStringExtra("PP_NO"),
            intent.getStringExtra("BOOKING_VOG"),
            intent.getStringExtra("BOOKING_BRANCH"),
            intent.getStringExtra("EX_BRANCH"),
            intent.getStringExtra("LOCATION"),
            intent.getStringExtra("PROJECT_MANAGER"),
            intent.getStringExtra("SUPER_VISOR")
        )

        arrayList = ArrayList<ItemListDataProject>()
        mItmViewModel?.getMainDataList(intent.getStringExtra("ID"), this, arrayList, recyclerView, llError)
    }

    private fun setUi(
        cusName: String?,
        cusCard: String?,
        ppNo: String?,
        bookingVog: String?,
        bookingBranch: String?,
        exBranch: String?,
        location: String?,
        projectManager: String?,
        supervisor: String?
    ) {

        tvCustomerName.setText(cusName)
        tvCustomerCard.setText(cusCard)
        tvBookingBranch.setText(bookingBranch)
        tvBookingVog.setText(bookingVog)
        tvExecuting.setText(exBranch)
        tvLocation.setText(location)
        tvPpno.setText(ppNo)
        tvProjectManageger.setText(projectManager)
        tvSupervisor.setText(supervisor)


    }

    override fun getViewModel(): ItmViewModel {
        mItmViewModel = ViewModelProviders.of(this, mViewModelFactory).get(ItmViewModel::class.java)
        return mItmViewModel as ItmViewModel
    }

    override fun getBindingVariable(): Int {
        return BR.viewModel
    }

    override fun getLayoutId(): Int {
        return R.layout.activity_item_list
    }


    private fun getIds(name: String) {

        mToolBar = findViewById(R.id.toolbar) as Toolbar
        setUpToolbar(R.drawable.ic_arrow_back_black_24dp, name)

    }


    private fun setUpToolbar(menu: Int, titleStr: String) {

        mToolBar.setContentInsetStartWithNavigation(0)

        toolBarTitel = mToolBar.findViewById(R.id.toolbar_title) as TextView
        imghome = mToolBar.findViewById(R.id.home) as ImageView
        imghome.setImageResource(menu)
        toolBarTitel.setText(titleStr)
        mToolBar.setNavigationIcon(null)

        imghome.setOnClickListener(View.OnClickListener {
            finish()
        })


    }
}
