package com.prrsoft.methodex.ui.fragment.marketwatch

import android.arch.lifecycle.ViewModel
import android.content.Context
import android.support.v4.app.FragmentActivity
import android.support.v4.app.FragmentManager
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.widget.Toast
import com.android.volley.NetworkError
import com.android.volley.Response
import com.android.volley.ServerError
import com.android.volley.TimeoutError
import com.google.gson.Gson
import com.prrsoft.methodex.CIApp
import com.prrsoft.methodex.R
import com.prrsoft.methodex.network.RequestForDeleateShareMarketData
import com.prrsoft.methodex.network.RequestForShareMarketList
import com.prrsoft.methodex.util.CommonUtil
import com.prrsoft.methodex.util.Constants
import com.prrsoft.methodex.util.Constants.Companion.KEY_USER_ID_PREF
import com.prrsoft.visitormanagment.PreferenceStore
import org.json.JSONException
import org.json.JSONObject
import org.json.JSONTokener
import java.util.ArrayList

class StockMarketViewModel : ViewModel() {

    fun getShareMarketList(
        activity: FragmentActivity?,
        userId: String,
        shareMarketList: ArrayList<SharemarketDataList>,
        recyclerView: RecyclerView?,
        frameContainer: Int,
        childFragmentManager: FragmentManager
    ) {


        CommonUtil.showLoadingDialog(activity)
        val loginRequest = RequestForShareMarketList(userId,
            Response.Listener<String> { response ->

                CommonUtil.hideDilog()
                try {
                    val json = JSONTokener(response).nextValue()
//                    val json = response
                    if (json is JSONObject) {

                        val status = if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                        val data = if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                        if (status == Constants.STATUS_SUCCESS) {

                            var sharemarketDataList = SharemarketDataList()
                            sharemarketDataList = Gson().fromJson(response, SharemarketDataList::class.java)
                            shareMarketList.add(sharemarketDataList)

                            recyclerView!!.layoutManager = LinearLayoutManager(activity)
//                            recyclerView.addItemDecoration(SimpleDividerItemDecoration(context))
                            recyclerView.adapter = ShareMarketListAdapter(
                                activity,
                                shareMarketList,
                                frameContainer,
                                childFragmentManager, recyclerView

                            )


                        } else if (status == Constants.STATUS_EXCEPTION) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                        } else if (status == Constants.STATUS_FAILURE) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                        }
                    } else {
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                    Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                }
            },
            Response.ErrorListener { error ->
                CommonUtil.hideDilog()
                if (error is ServerError)
                    Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                else if (error is TimeoutError)
                    Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                else if (error is NetworkError)
                    Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
            })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)
    }

    fun deleateRecord(
        companyId: String?,
        context: Context,
        shareMarketListArray: ArrayList<SharemarketDataList>,
        layoutPosition: Int,
        recyclerView: RecyclerView,
        shareMarket: ShareMarketList
    ) {

        CommonUtil.showLoadingDialog(context)
        val loginRequest =
            RequestForDeleateShareMarketData(PreferenceStore.getPreference(context).getString(KEY_USER_ID_PREF),
                companyId!!,
                Response.Listener<String> { response ->

                    CommonUtil.hideDilog()
                    try {
                        val json = JSONTokener(response).nextValue()
//                    val json = response
                        if (json is JSONObject) {

                            val status =
                                if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                            val data =
                                if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                            if (status == Constants.STATUS_SUCCESS) {

                                Toast.makeText(context, data, Toast.LENGTH_SHORT).show()

                            } else if (status == Constants.STATUS_EXCEPTION) {
                                Toast.makeText(context, data, Toast.LENGTH_SHORT).show()
                            } else if (status == Constants.STATUS_FAILURE) {
                                Toast.makeText(context, data, Toast.LENGTH_SHORT).show()

                            }
                        } else {
                            Toast.makeText(context, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                        }
                    } catch (e: JSONException) {
                        e.printStackTrace()
                        Toast.makeText(context, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                },
                Response.ErrorListener { error ->
                    CommonUtil.hideDilog()
                    if (error is ServerError)
                        Toast.makeText(context, "Server Error", Toast.LENGTH_SHORT).show()
                    else if (error is TimeoutError)
                        Toast.makeText(context, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                    else if (error is NetworkError)
                        Toast.makeText(context, "Bad Network Connection", Toast.LENGTH_SHORT).show()
                })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)
    }
}
