package com.prrsoft.methodex.ui.fragment.home

import android.arch.lifecycle.ViewModel;
import android.support.v4.app.Fragment
import android.support.v4.app.FragmentActivity
import android.support.v4.app.FragmentManager
import android.widget.TextView
import android.widget.Toast
import com.android.volley.NetworkError
import com.android.volley.Response
import com.android.volley.ServerError
import com.android.volley.TimeoutError
import com.google.gson.Gson
import com.prrsoft.methodex.CIApp
import com.prrsoft.methodex.R
import com.prrsoft.methodex.network.RequestHomeFragment
import com.prrsoft.methodex.util.CommonUtil
import com.prrsoft.methodex.util.Constants
import com.prrsoft.methodex.util.Constants.Companion.KEY_RESPONSE
import com.prrsoft.methodex.util.Constants.Companion.KEY_STATUS
import com.prrsoft.methodex.util.Constants.Companion.STATUS_EXCEPTION
import com.prrsoft.methodex.util.Constants.Companion.STATUS_FAILURE
import com.prrsoft.methodex.util.Constants.Companion.STATUS_SUCCESS
import org.json.JSONException
import org.json.JSONObject
import org.json.JSONTokener

class HomeViewModel : ViewModel() {

    val homeDataListArray = ArrayList<HomeDataList>()
    fun getTopTips(
        activity: FragmentActivity?,
        tvCEDate: TextView,
        tvBuyRange: TextView,
        tvQuantity: TextView,
        tvInvestment: TextView,
        tvCellPrice: TextView
    ) {

        CommonUtil.showLoadingDialog(activity)
        val loginRequest = RequestHomeFragment(
            Response.Listener<String> { response ->

                CommonUtil.hideDilog()
                try {
                    val json = JSONTokener(response).nextValue()
//                    val json = response
                    if (json is JSONObject) {

                        val status = if (json.has(KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                        val data = if (json.has(KEY_RESPONSE)) json.getString(KEY_RESPONSE) else ""
                        if (status == STATUS_SUCCESS) {

                            var homeDataList = HomeDataList()
                            homeDataList = Gson().fromJson(response, HomeDataList::class.java)
                            homeDataListArray.add(homeDataList)

                            tvCEDate.setText(
                                homeDataListArray[0].topTipsList?.get(0)?.companyName + " " + homeDataListArray[0].topTipsList?.get(
                                    0
                                )?.ce + " CE -" + homeDataListArray[0].topTipsList?.get(
                                    0
                                )?.expiryDate
                            )
                            tvBuyRange.setText("Buy Range =" + homeDataListArray[0].topTipsList?.get(0)?.ranges)
                            tvQuantity.setText("Recommanded Qty =" + homeDataListArray[0].topTipsList?.get(0)?.quantity)
                            tvInvestment.setText("Total Investment =" + homeDataListArray[0].topTipsList?.get(0)?.investment)
                            tvCellPrice.setText("Total Investment =" + homeDataListArray[0].topTipsList?.get(0)?.buyTipPrice)


                        } else if (status == STATUS_EXCEPTION) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                        } else if (status == STATUS_FAILURE) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                        }
                    } else {
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                    Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                }
            },
            Response.ErrorListener { error ->
                CommonUtil.hideDilog()
                if (error is ServerError)
                    Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                else if (error is TimeoutError)
                    Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                else if (error is NetworkError)
                    Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
            })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)
    }

    fun loadFragment(
        childFragmentManager: FragmentManager,
        frameContainer: Int,
        fragments: Fragment,
        tag: String
    ) {


//        val mBundle = Bundle()
////        mBundle.putParcelable("item_selected_key", mItemSelected)
////        mBundle.putParcelableArrayList("isSelectedArray",mItemSelected)
//        mBundle.putString("NEWS_ID", "" + "")
//        fragments.setArguments(mBundle)

//        childFragmentManager.popBackStackImmediate(tag, FragmentManager.POP_BACK_STACK_INCLUSIVE);
        childFragmentManager.beginTransaction().replace(frameContainer, fragments).commit()

    }


}
