package com.prrsoft.methodex.ui.fragment.freetips

import android.os.Bundle
import android.support.v4.app.FragmentActivity
import android.support.v4.app.FragmentManager
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import com.prrsoft.methodex.R
import com.prrsoft.methodex.ui.fragment.bossTips.TipsDataList
import com.prrsoft.methodex.ui.fragment.bossTips.TipsList
import com.prrsoft.methodex.ui.fragment.newsDetailsFragment.NewsDetailsFragment
import kotlinx.android.synthetic.main.boss_tips_single_layout.view.*
import java.util.ArrayList

class FreeTipsListAdapter(
    private val context: FragmentActivity? = null,
    private val tipsDataListArray: ArrayList<TipsDataList>,
    private val frameContainer: Int,
    private val childFragmentManager: FragmentManager,
    private val recyclerView: RecyclerView,
    private val llError: LinearLayout
) :
    RecyclerView.Adapter<FreeTipsListAdapter.HomeViewHolder>() {


    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): HomeViewHolder {
        val view = LayoutInflater.from(context).inflate(R.layout.free_tips_single_layout, parent, false)
        return HomeViewHolder(view)
    }

    override fun getItemCount(): Int {
        if (tipsDataListArray.size == 0) {
            llError.visibility = View.VISIBLE
            return 0
        }
        if (tipsDataListArray[0].tipsList?.size == null) {
            llError.visibility = View.VISIBLE
            return 0
        }
        llError.visibility = View.GONE
        return tipsDataListArray[0].tipsList!!.size
    }


    override fun onBindViewHolder(holder: HomeViewHolder, position: Int) {
        tipsDataListArray[0].tipsList?.get(position)?.let { holder.bind(it) }
    }

    inner class HomeViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        fun bind(tipsList: TipsList) = with(itemView) {
            //            val requestOptions = RequestOptions()
//            requestOptions.placeholder(R.drawable.logo)
//            Glide.with(this.context)
//                .load(Constants.BASE_IMAGE_URL + shareMarket.image)
//                .apply(requestOptions)
//                .into(ivNewsIcon)

            llBooss.visibility = View.VISIBLE
            if (tipsList.callType.equals("sell")) {

                cvBuyCall.visibility = View.GONE
                cvSellCall.visibility = View.VISIBLE
            } else {
                cvBuyCall.visibility = View.VISIBLE
                cvSellCall.visibility = View.GONE
            }

            tvCompanyName.text =
                tipsList.companyName
            tvCurrent.text = ": " + tipsList.currentMarketPrice
            tvRange.text = ": " + tipsList.ranges
            tvStopLoss.text = ": " + tipsList.stopLoss
            tvTarget.text = ": " + tipsList.target
            tvTargetStatus.text = ": " + tipsList.targetStatus
            tvTimeDate.text = tipsList.time + " " + tipsList.date

            setOnClickListener {


            }


        }
    }

    private fun fragmentJump(
        mItemSelected: List<TipsList>?,
        layoutPosition: Int
    ) {
        val mFragment = NewsDetailsFragment()
        val mBundle = Bundle()
//        mBundle.putParcelable("item_selected_key", mItemSelected)
//        mBundle.putParcelableArrayList("isSelectedArray",mItemSelected)
        mBundle.putString("NEWS_ID", "" + mItemSelected?.get(layoutPosition)?.id)
        mFragment.setArguments(mBundle)
        childFragmentManager.beginTransaction().replace(frameContainer, mFragment).addToBackStack(null).commit()
    }


}


