package com.prrsoft.methodex.ui.fragment.bosstipsplan

import android.arch.lifecycle.ViewModel;
import android.support.v4.app.FragmentActivity
import android.support.v4.app.FragmentManager
import android.support.v7.widget.LinearLayoutManager
import android.support.v7.widget.RecyclerView
import android.widget.TextView
import android.widget.Toast
import com.android.volley.NetworkError
import com.android.volley.Response
import com.android.volley.ServerError
import com.android.volley.TimeoutError
import com.google.gson.Gson
import com.prrsoft.methodex.CIApp
import com.prrsoft.methodex.R
import com.prrsoft.methodex.network.RequestForTermAndCondition
import com.prrsoft.methodex.network.RerquestForBossTipsPlan
import com.prrsoft.methodex.util.CommonUtil
import com.prrsoft.methodex.util.Constants
import org.json.JSONException
import org.json.JSONObject
import org.json.JSONTokener
import java.util.ArrayList

class BossTipsPlanViewModel : ViewModel() {

    fun getBossTipsPlans(
        activity: FragmentActivity?,
        userId: String,
        planDataList: ArrayList<PlanDataList>,
        recyclerView: RecyclerView?,
        frameContainer: Int,
        childFragmentManager: FragmentManager
    ) {


        CommonUtil.showLoadingDialog(activity)
        val loginRequest = RerquestForBossTipsPlan(
            Response.Listener<String> { response ->

                CommonUtil.hideDilog()
                try {
                    val json = JSONTokener(response).nextValue()
//                    val json = response
                    if (json is JSONObject) {

                        val status = if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                        val data = if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                        if (status == Constants.STATUS_SUCCESS) {

                            var planData = PlanDataList()
                            planData = Gson().fromJson(response, PlanDataList::class.java)
                            planDataList.add(planData)

                            recyclerView!!.layoutManager = LinearLayoutManager(activity)
//                            recyclerView.addItemDecoration(SimpleDividerItemDecoration(context))
                            recyclerView.adapter = BossTipsPlanAdapter(
                                activity,
                                planDataList,
                                frameContainer,
                                childFragmentManager, recyclerView

                            )


                        } else if (status == Constants.STATUS_EXCEPTION) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                        } else if (status == Constants.STATUS_FAILURE) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                        }
                    } else {
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                    Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                }
            },
            Response.ErrorListener { error ->
                CommonUtil.hideDilog()
                if (error is ServerError)
                    Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                else if (error is TimeoutError)
                    Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                else if (error is NetworkError)
                    Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
            })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)
    }

    fun getTremAndCondition(
        tvTermAndCondition: TextView?,
        activity: FragmentActivity
    ) {


        val loginRequest = RequestForTermAndCondition(
            Response.Listener<String> { response ->

                try {
                    val json = JSONTokener(response).nextValue()
//                    val json = response
                    if (json is JSONObject) {

                        val status = if (json.has(Constants.KEY_STATUS)) json.getString(Constants.KEY_STATUS) else ""
                        val data = if (json.has(Constants.KEY_RESPONSE)) json.getString(Constants.KEY_RESPONSE) else ""
                        if (status == Constants.STATUS_SUCCESS) {


                            val term = json.getJSONArray("terms_conditions").getJSONObject(0).optString("terms")

                            tvTermAndCondition!!.setText(term)

                        } else if (status == Constants.STATUS_EXCEPTION) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()
                        } else if (status == Constants.STATUS_FAILURE) {
                            Toast.makeText(activity, data, Toast.LENGTH_SHORT).show()

                        }
                    } else {
                        Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                    }
                } catch (e: JSONException) {
                    e.printStackTrace()
                    Toast.makeText(activity, R.string.someting_went_wrong, Toast.LENGTH_SHORT).show()
                }
            },
            Response.ErrorListener { error ->
                if (error is ServerError)
                    Toast.makeText(activity, "Server Error", Toast.LENGTH_SHORT).show()
                else if (error is TimeoutError)
                    Toast.makeText(activity, "Connection Timed Out", Toast.LENGTH_SHORT).show()
                else if (error is NetworkError)
                    Toast.makeText(activity, "Bad Network Connection", Toast.LENGTH_SHORT).show()
            })
//        loginRequest.setTag(TAG)
        CIApp.instance?.addToRequestQueue(loginRequest)


    }


}
